/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.server.common.MetadataVersion;

public record FinalizedFeatures(MetadataVersion metadataVersion, Map<String, Short> finalizedFeatures, long finalizedFeaturesEpoch) {
    public FinalizedFeatures(MetadataVersion metadataVersion, Map<String, Short> finalizedFeatures, long finalizedFeaturesEpoch) {
        this.metadataVersion = Objects.requireNonNull(metadataVersion);
        this.finalizedFeatures = new HashMap<String, Short>(finalizedFeatures);
        this.finalizedFeaturesEpoch = finalizedFeaturesEpoch;
        this.finalizedFeatures.put("confluent.metadata.version", metadataVersion.confluentFeatureLevel());
        this.finalizedFeatures.remove("metadata.version");
    }

    public static FinalizedFeatures fromKRaftVersion(MetadataVersion version) {
        return new FinalizedFeatures(version, Map.of(), -1L);
    }

    public FinalizedFeatures setFinalizedLevel(String key, short level) {
        if (level == 0) {
            if (this.finalizedFeatures.containsKey(key)) {
                HashMap<String, Short> newFinalizedFeatures = new HashMap<String, Short>(this.finalizedFeatures);
                newFinalizedFeatures.remove(key);
                return new FinalizedFeatures(this.metadataVersion, newFinalizedFeatures, this.finalizedFeaturesEpoch);
            }
            return this;
        }
        HashMap<String, Short> newFinalizedFeatures = new HashMap<String, Short>(this.finalizedFeatures);
        newFinalizedFeatures.put(key, level);
        return new FinalizedFeatures(this.metadataVersion, newFinalizedFeatures, this.finalizedFeaturesEpoch);
    }
}

