/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.image.publisher;

import io.confluent.k2.kafka.K2TopicMetadata;
import io.confluent.k2.kafka.image.publisher.K2MetadataPublisher;
import io.confluent.k2.kafka.image.publisher.K2TopicsImageAndVersion;
import io.confluent.kafka.image.publisher.K2KRaftMetadataPublisherHelper;
import io.confluent.kafka.multitenant.TenantUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.image.ConfigurationImage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.slf4j.Logger;

public class TenantMetricsPublisher
implements MetadataPublisher,
K2MetadataPublisher,
K2KRaftMetadataPublisherHelper.Callback<MetadataImage, MetadataDelta> {
    private final FaultHandler faultHandler;
    private K2KRaftMetadataPublisherHelper<MetadataImage, MetadataDelta> k2KRaftMetadataPublisherHelper = null;
    private final KafkaMetricsGroup registry;
    private final String nodeType;
    protected Map<String, PartitionCountMetricByCleanupPolicy> tenantPartitionCountTracker;
    private Function<String, Boolean> registerTenantGaugeInterface;
    private Function<String, Boolean> removeTenantGaugeInterface;
    private Function<String, Boolean> isTenantOwnedInterface;
    private final Set<String> registeredTenants;
    private Long lastUpdateTime;
    private static final char TENANT_DELIMITER = '_';
    private LogContext logContext = new LogContext();
    private final Logger log;

    public static TenantMetricsPublisher newInstance(FaultHandler faultHandler, String nodeType) {
        TenantMetricsPublisher publisher = new TenantMetricsPublisher(faultHandler, nodeType);
        publisher.k2KRaftMetadataPublisherHelper = new K2KRaftMetadataPublisherHelper<MetadataImage, MetadataDelta>(MetadataImage.EMPTY, () -> new MetadataDelta(MetadataImage.EMPTY, __ -> null, new MetadataEncryptorFactory()), (__, ___) -> true, (__, ___) -> "KRaft MetadataDelta", (__, ___) -> true, publisher);
        return publisher;
    }

    private TenantMetricsPublisher(FaultHandler faultHandler, String nodeType) {
        this.faultHandler = faultHandler;
        this.registry = new KafkaMetricsGroup(this.getClass());
        this.nodeType = nodeType;
        this.tenantPartitionCountTracker = new ConcurrentHashMap<String, PartitionCountMetricByCleanupPolicy>();
        this.lastUpdateTime = System.currentTimeMillis();
        this.log = this.logContext.logger(TenantMetricsPublisher.class);
        this.registeredTenants = new HashSet<String>();
    }

    public String name() {
        return "TenantMetadataPublisher";
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        this.k2KRaftMetadataPublisherHelper.maybePublishKRaftImageAndDelta(newImage, delta, manifest);
    }

    public void onK2MetadataUpdate(K2TopicsImageAndVersion currentK2TopicsImageAndVersion) {
        this.k2KRaftMetadataPublisherHelper.maybePublishK2ImageAndVersion(currentK2TopicsImageAndVersion);
    }

    public void setTenantRegisterInterface(Function<String, Boolean> registerTenantGaugeInterface) {
        this.registerTenantGaugeInterface = registerTenantGaugeInterface;
    }

    public void setIsTenantOwnedInterface(Function<String, Boolean> isTenantOwnedInterface) {
        this.isTenantOwnedInterface = isTenantOwnedInterface;
    }

    public void setRemoveTenantGaugeInterface(Function<String, Boolean> removeTenantGaugeInterface) {
        this.removeTenantGaugeInterface = removeTenantGaugeInterface;
    }

    protected void setLastUpdateTime(Long time) {
        this.lastUpdateTime = time;
    }

    @Override
    public void doPublish(MetadataImage currentKRaftImage, MetadataDelta currentKRaftDelta, LoaderManifest manifest, K2TopicsImageAndVersion prevK2TopicsImageAndVersion, K2TopicsImageAndVersion currentK2TopicsImageAndVersion, boolean dueToKRaftChange, String description) {
        try {
            Set tenantSet = Stream.concat(currentKRaftImage.topics().topicNamesByTenant().keySet().stream(), currentK2TopicsImageAndVersion.image().topicNameToId().keySet().stream().map(topicName -> TenantUtils.extractTenantPrefix((String)topicName, (boolean)true)).filter(Objects::nonNull).collect(Collectors.toSet()).stream()).collect(Collectors.toSet());
            boolean shouldUpdate = this.shouldUpdate();
            if (shouldUpdate) {
                this.lastUpdateTime = System.currentTimeMillis();
                this.log.info("Clearing the tenantPartitionCountTracker");
                this.tenantPartitionCountTracker.clear();
            }
            for (String tenant : tenantSet) {
                Boolean isTenantPresent = this.tenantPartitionCountTracker.containsKey(tenant);
                if (isTenantPresent.booleanValue() && !shouldUpdate) continue;
                this.updatePartitionCountMetricForTenant(tenant, currentKRaftImage, currentK2TopicsImageAndVersion);
            }
            if (shouldUpdate) {
                for (String tenant : tenantSet) {
                    this.maybeRegisterTenantGauge(tenant);
                }
            }
        }
        catch (Throwable e) {
            this.faultHandler.handleFault("Failed to compute Tenant partition count metric " + String.valueOf(dueToKRaftChange ? manifest.provenance() : "K2 image at (local, soft-state) topics version " + currentK2TopicsImageAndVersion.topicIdToNameVersion() + " and assignments version " + currentK2TopicsImageAndVersion.assignmentsVersion() + ")"), e);
        }
    }

    protected void maybeRegisterTenantGauge(String tenant) {
        try {
            Optional<String> originalTenantName = TenantMetricsPublisher.getOriginalTenantName(tenant);
            if (originalTenantName.isPresent() && this.registerTenantGaugeInterface != null && this.isTenantOwnedInterface != null && this.isTenantOwnedInterface.apply(originalTenantName.get()).booleanValue() && !this.registeredTenants.contains(originalTenantName.get())) {
                this.registerTenantGaugeInterface.apply(originalTenantName.get());
                this.registeredTenants.add(originalTenantName.get());
            }
        }
        catch (Exception e) {
            this.log.error("Error registering gauge in tenant metrics publisher for tenant {}", (Object)tenant);
        }
    }

    protected void maybeRemoveTenantGauges() {
        Iterator<String> iterator = this.registeredTenants.iterator();
        while (iterator.hasNext()) {
            String tenant = iterator.next();
            try {
                Optional<String> originalTenantName = TenantMetricsPublisher.getOriginalTenantName(tenant);
                if (!originalTenantName.isPresent() || this.removeTenantGaugeInterface == null || this.isTenantOwnedInterface == null || this.isTenantOwnedInterface.apply(originalTenantName.get()).booleanValue() || !this.registeredTenants.contains(originalTenantName.get())) continue;
                this.removeTenantGaugeInterface.apply(originalTenantName.get());
                iterator.remove();
            }
            catch (Exception e) {
                this.log.error("Error removing gauge in tenant metrics publisher for tenant {}", (Object)tenant);
            }
        }
    }

    protected Set<String> registeredTenants() {
        return Collections.unmodifiableSet(this.registeredTenants);
    }

    protected void updatePartitionCountMetricForTenant(String tenant, MetadataImage newImage, K2TopicsImageAndVersion currentK2TopicsImageAndVersion) {
        Set allTopicsForTenant = Stream.concat(newImage.topics().topicsByTenant(tenant).stream(), currentK2TopicsImageAndVersion.image().topicNameToId().keySet().stream().filter(name -> name.startsWith(tenant))).collect(Collectors.toSet());
        Map configs = newImage.configs().resourceData();
        HashSet<String> compactedTopics = new HashSet<String>();
        for (Map.Entry config : configs.entrySet()) {
            String topicNameInConfig;
            if (!((ConfigResource)config.getKey()).type().equals((Object)ConfigResource.Type.TOPIC) || !allTopicsForTenant.contains(topicNameInConfig = ((ConfigResource)config.getKey()).name()) || !((ConfigurationImage)config.getValue()).data().containsKey("cleanup.policy") || !((String)((ConfigurationImage)config.getValue()).data().get("cleanup.policy")).equals("compact")) continue;
            compactedTopics.add(topicNameInConfig);
        }
        Long compactedPartitionCount = 0L;
        Long nonCompactedPartitionCont = 0L;
        for (String topic : allTopicsForTenant) {
            int partitionCount;
            TopicImage kraftTopicImage = (TopicImage)newImage.topics().topicsByName().get((Object)topic);
            int n = partitionCount = kraftTopicImage != null ? kraftTopicImage.partitions().size() : ((K2TopicMetadata)currentK2TopicsImageAndVersion.image().topicNameToMetadata().get((Object)topic)).numPartitions();
            if (compactedTopics.contains(topic)) {
                compactedPartitionCount = compactedPartitionCount + (long)partitionCount;
                continue;
            }
            nonCompactedPartitionCont = nonCompactedPartitionCont + (long)partitionCount;
        }
        this.updatePartitionCountMetric(tenant, compactedPartitionCount, nonCompactedPartitionCont);
    }

    protected void updatePartitionCountMetric(String tenant, Long compactedPartitionCount, Long nonCompactedPartitionCont) {
        if (tenant != null) {
            this.tenantPartitionCountTracker.put(tenant, new PartitionCountMetricByCleanupPolicy(compactedPartitionCount, nonCompactedPartitionCont));
            this.maybeRegisterMetric(tenant);
        }
    }

    private void maybeRegisterMetric(String tenant) {
        if (this.nodeType.equals("Controller")) {
            this.registry.newGauge("PartitionCountCompacted", () -> this.getCompactedPartitionCountForTenant(tenant), Map.of("tenant", TenantMetricsPublisher.getOriginalTenantName(tenant).get()));
            this.registry.newGauge("PartitionCountNonCompacted", () -> this.getNonCompactedPartitionCountForTenant(tenant), Map.of("tenant", TenantMetricsPublisher.getOriginalTenantName(tenant).get()));
        }
    }

    protected String getModifiedTenantName(String tenant) {
        return tenant + "_";
    }

    protected static Optional<String> getOriginalTenantName(String tenant) {
        if (!tenant.isEmpty() && tenant.charAt(tenant.length() - 1) == '_') {
            return Optional.of(tenant.substring(0, tenant.length() - 1));
        }
        return Optional.of(tenant);
    }

    protected boolean shouldUpdate() {
        return this.lastUpdateTime + TenantUtils.getTenantPartitionCountUpdateThresholdInMs() < System.currentTimeMillis();
    }

    public PartitionCountMetricByCleanupPolicy getPartitionCountForTenant(String tenant) {
        if (!this.tenantPartitionCountTracker.containsKey(this.getModifiedTenantName(tenant))) {
            throw new RuntimeException("PartitionCount by cleanup policy is not available for given tenant");
        }
        return this.tenantPartitionCountTracker.get(this.getModifiedTenantName(tenant));
    }

    public Long getCompactedPartitionCountForTenant(String tenant) {
        if (!this.tenantPartitionCountTracker.containsKey(tenant)) {
            return 0L;
        }
        return this.tenantPartitionCountTracker.get((Object)tenant).partitionCountCompacted;
    }

    public Long getNonCompactedPartitionCountForTenant(String tenant) {
        if (!this.tenantPartitionCountTracker.containsKey(tenant)) {
            return 0L;
        }
        return this.tenantPartitionCountTracker.get((Object)tenant).partitionCountNonCompacted;
    }

    public void close() {
        this.tenantPartitionCountTracker.clear();
    }

    public static final class PartitionCountMetricByCleanupPolicy {
        private final Long partitionCountCompacted;
        private final Long partitionCountNonCompacted;

        public PartitionCountMetricByCleanupPolicy() {
            this.partitionCountCompacted = 0L;
            this.partitionCountNonCompacted = 0L;
        }

        PartitionCountMetricByCleanupPolicy(Long partitionCountCompacted, Long partitionCountNonCompacted) {
            this.partitionCountCompacted = partitionCountCompacted;
            this.partitionCountNonCompacted = partitionCountNonCompacted;
        }

        public Long getPartitionCountCompacted() {
            return this.partitionCountCompacted;
        }

        public Long getPartitionCountNonCompacted() {
            return this.partitionCountNonCompacted;
        }

        public String toString() {
            return this.partitionCountCompacted + ":" + this.partitionCountNonCompacted;
        }
    }
}

