/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.network.metrics;

import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;

public class RequestMetrics {
    public static final String CONSUMER_FETCH_METRIC_NAME = ApiKeys.FETCH.name + "Consumer";
    public static final String FOLLOW_FETCH_METRIC_NAME = ApiKeys.FETCH.name + "Follower";
    public static final String VERIFY_PARTITIONS_IN_TXN_METRIC_NAME = ApiKeys.ADD_PARTITIONS_TO_TXN.name + "Verification";
    public static final String LIST_CLIENT_METRICS_RESOURCES_METRIC_NAME = "ListClientMetricsResources";
    public static final String REQUESTS_PER_SEC = "RequestsPerSec";
    public static final String DEPRECATED_REQUESTS_PER_SEC = "DeprecatedRequestsPerSec";
    public static final String MESSAGE_CONVERSIONS_TIME_MS = "MessageConversionsTimeMs";
    public static final String TEMPORARY_MEMORY_BYTES = "TemporaryMemoryBytes";
    private static final String REQUEST_QUEUE_TIME_MS = "RequestQueueTimeMs";
    private static final String LOCAL_TIME_MS = "LocalTimeMs";
    private static final String REMOTE_TIME_MS = "RemoteTimeMs";
    private static final String THROTTLE_TIME_MS = "ThrottleTimeMs";
    private static final String RESPONSE_QUEUE_TIME_MS = "ResponseQueueTimeMs";
    private static final String RESPONSE_SEND_TIME_MS = "ResponseSendTimeMs";
    private static final String RESPONSE_SEND_IO_TIME_MS = "ResponseSendIoTimeMs";
    private static final String TOTAL_TIME_MS = "TotalTimeMs";
    private static final String HEALTH_CHECK_TOTAL_TIME_MS = "HealthCheckTotalTimeMs";
    private static final String REQUEST_BYTES = "RequestBytes";
    private static final String ERRORS_PER_SEC = "ErrorsPerSec";
    private static final long SLOW_LOG_P99_CACHE_REFRESH_THRESHOLD_NANOS = TimeUnit.SECONDS.toNanos(60L);
    public final Histogram requestQueueTimeHist;
    public final Histogram localTimeHist;
    public final Histogram remoteTimeHist;
    public final Histogram throttleTimeHist;
    public final Histogram responseQueueTimeHist;
    public final Histogram responseSendTimeHist;
    public final Histogram responseSendIoTimeHist;
    public final Histogram totalTimeHist;
    public final Histogram healthCheckTotalTimeHist;
    public final Histogram requestBytesHist;
    public final Optional<Histogram> messageConversionsTimeHist;
    public final Optional<Histogram> tempMemoryBytesHist;
    public volatile CachedP99Time cachedP99Time;
    private final KafkaMetricsGroup metricsGroup = new KafkaMetricsGroup("kafka.network", "RequestMetrics");
    private final String name;
    private final Map<String, String> tags;
    private final ConcurrentMap<Short, Meter> requestRateInternal = new ConcurrentHashMap<Short, Meter>();
    private final ConcurrentMap<DeprecatedRequestRateKey, Meter> deprecatedRequestRateInternal = new ConcurrentHashMap<DeprecatedRequestRateKey, Meter>();
    private final Map<Errors, ErrorMeter> errorMeters = new EnumMap<Errors, ErrorMeter>(Errors.class);

    public RequestMetrics(String name) {
        this.name = name;
        this.tags = Map.of("request", name);
        this.requestQueueTimeHist = this.metricsGroup.newHistogram(REQUEST_QUEUE_TIME_MS, true, this.tags);
        this.localTimeHist = this.metricsGroup.newHistogram(LOCAL_TIME_MS, true, this.tags);
        this.remoteTimeHist = this.metricsGroup.newHistogram(REMOTE_TIME_MS, true, this.tags);
        this.throttleTimeHist = this.metricsGroup.newHistogram(THROTTLE_TIME_MS, true, this.tags);
        this.responseQueueTimeHist = this.metricsGroup.newHistogram(RESPONSE_QUEUE_TIME_MS, true, this.tags);
        this.responseSendTimeHist = this.metricsGroup.newHistogram(RESPONSE_SEND_TIME_MS, true, this.tags);
        this.responseSendIoTimeHist = this.metricsGroup.newHistogram(RESPONSE_SEND_IO_TIME_MS, true, this.tags);
        this.totalTimeHist = this.metricsGroup.newHistogram(TOTAL_TIME_MS, true, this.tags);
        this.healthCheckTotalTimeHist = this.metricsGroup.newHistogram(HEALTH_CHECK_TOTAL_TIME_MS, true, this.tags);
        this.requestBytesHist = this.metricsGroup.newHistogram(REQUEST_BYTES, true, this.tags);
        this.messageConversionsTimeHist = this.isFetchOrProduce(name) ? Optional.of(this.metricsGroup.newHistogram(MESSAGE_CONVERSIONS_TIME_MS, true, this.tags)) : Optional.empty();
        this.tempMemoryBytesHist = this.isFetchOrProduce(name) ? Optional.of(this.metricsGroup.newHistogram(TEMPORARY_MEMORY_BYTES, true, this.tags)) : Optional.empty();
        this.cachedP99Time = new CachedP99Time(0L, 0.0);
        for (Errors error : Errors.values()) {
            this.errorMeters.put(error, new ErrorMeter(name, error));
        }
    }

    public Meter requestRate(short version) {
        return this.requestRateInternal.computeIfAbsent(version, v -> this.metricsGroup.newMeter(REQUESTS_PER_SEC, "requests", TimeUnit.SECONDS, this.tagsWithVersion((short)v)));
    }

    public Double cachedTotalTimeMsP99(long startTimeNanos) {
        if (startTimeNanos - this.cachedP99Time.lastUpdatedTime > SLOW_LOG_P99_CACHE_REFRESH_THRESHOLD_NANOS) {
            this.cachedP99Time = new CachedP99Time(startTimeNanos, this.totalTimeHist.getSnapshot().get99thPercentile());
        }
        return this.cachedP99Time.p99TotalTime;
    }

    public Optional<Meter> deprecatedRequestRate(ApiKeys apiKey, short version, ClientInformation clientInformation) {
        if (apiKey.isVersionDeprecated(version)) {
            return Optional.of(this.deprecatedRequestRateInternal.computeIfAbsent(new DeprecatedRequestRateKey(version, clientInformation), k -> this.metricsGroup.newMeter(DEPRECATED_REQUESTS_PER_SEC, "requests", TimeUnit.SECONDS, this.tagsWithVersionAndClientInfo(version, clientInformation))));
        }
        return Optional.empty();
    }

    public void markErrorMeter(Errors error, int count) {
        this.errorMeters.get(error).getOrCreateMeter().mark((long)count);
    }

    private Map<String, String> tagsWithVersion(short version) {
        LinkedHashMap<String, String> nameAndVersionTags = new LinkedHashMap<String, String>((int)Math.ceil((double)(this.tags.size() + 1) / 0.75));
        nameAndVersionTags.putAll(this.tags);
        nameAndVersionTags.put("version", String.valueOf(version));
        return nameAndVersionTags;
    }

    private Map<String, String> tagsWithVersionAndClientInfo(short version, ClientInformation clientInformation) {
        LinkedHashMap<String, String> extendedTags = new LinkedHashMap<String, String>((int)Math.ceil((double)(this.tags.size() + 3) / 0.75));
        extendedTags.putAll(this.tags);
        extendedTags.put("version", String.valueOf(version));
        extendedTags.put("clientSoftwareName", clientInformation.softwareName());
        extendedTags.put("clientSoftwareVersion", clientInformation.softwareVersion());
        return extendedTags;
    }

    void removeMetrics() {
        Iterator<Object> iterator = this.requestRateInternal.keySet().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            this.metricsGroup.removeMetric(REQUESTS_PER_SEC, this.tagsWithVersion(version));
        }
        for (DeprecatedRequestRateKey key : this.deprecatedRequestRateInternal.keySet()) {
            this.metricsGroup.removeMetric(DEPRECATED_REQUESTS_PER_SEC, this.tagsWithVersionAndClientInfo(key.version, key.clientInformation));
        }
        this.metricsGroup.removeMetric(REQUEST_QUEUE_TIME_MS, this.tags);
        this.metricsGroup.removeMetric(LOCAL_TIME_MS, this.tags);
        this.metricsGroup.removeMetric(REMOTE_TIME_MS, this.tags);
        this.metricsGroup.removeMetric(REQUESTS_PER_SEC, this.tags);
        this.metricsGroup.removeMetric(THROTTLE_TIME_MS, this.tags);
        this.metricsGroup.removeMetric(RESPONSE_QUEUE_TIME_MS, this.tags);
        this.metricsGroup.removeMetric(TOTAL_TIME_MS, this.tags);
        this.metricsGroup.removeMetric(HEALTH_CHECK_TOTAL_TIME_MS, this.tags);
        this.metricsGroup.removeMetric(RESPONSE_SEND_TIME_MS, this.tags);
        this.metricsGroup.removeMetric(RESPONSE_SEND_IO_TIME_MS, this.tags);
        this.metricsGroup.removeMetric(REQUEST_BYTES, this.tags);
        if (this.isFetchOrProduce(this.name)) {
            this.metricsGroup.removeMetric(MESSAGE_CONVERSIONS_TIME_MS, this.tags);
            this.metricsGroup.removeMetric(TEMPORARY_MEMORY_BYTES, this.tags);
        }
        for (ErrorMeter errorMeter : this.errorMeters.values()) {
            errorMeter.removeMeter();
        }
        this.errorMeters.clear();
    }

    private boolean isFetchOrProduce(String name) {
        return ApiKeys.FETCH.name.equals(name) || ApiKeys.PRODUCE.name.equals(name);
    }

    private class CachedP99Time {
        private final long lastUpdatedTime;
        private final double p99TotalTime;

        CachedP99Time(long lastUpdatedTime, double p99TotalTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            this.p99TotalTime = p99TotalTime;
        }

        public long lastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public double p99TotalTime() {
            return this.p99TotalTime;
        }
    }

    private class ErrorMeter {
        private final Map<String, String> tags = new LinkedHashMap<String, String>();
        private volatile Meter meter;

        private ErrorMeter(String name, Errors error) {
            this.tags.put("request", name);
            this.tags.put("error", error.name());
        }

        private synchronized Meter getOrCreateMeter() {
            if (this.meter == null) {
                this.meter = RequestMetrics.this.metricsGroup.newMeter(RequestMetrics.ERRORS_PER_SEC, "requests", TimeUnit.SECONDS, this.tags);
            }
            return this.meter;
        }

        private synchronized void removeMeter() {
            if (this.meter != null) {
                RequestMetrics.this.metricsGroup.removeMetric(RequestMetrics.ERRORS_PER_SEC, this.tags);
                this.meter = null;
            }
        }
    }

    private static class DeprecatedRequestRateKey {
        private final short version;
        private final ClientInformation clientInformation;

        private DeprecatedRequestRateKey(short version, ClientInformation clientInformation) {
            this.version = version;
            this.clientInformation = clientInformation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeprecatedRequestRateKey that = (DeprecatedRequestRateKey)o;
            return this.version == that.version && Objects.equals(this.clientInformation, that.clientInformation);
        }

        public int hashCode() {
            return Objects.hash(this.version, this.clientInformation);
        }
    }

    public static class TenantRequestMetrics {
        private KafkaMetricsGroup metricsGroup = new KafkaMetricsGroup(this.getClass());
        private Map<String, String> tags = new HashMap<String, String>();
        private Histogram tenantTotalTimeHist;
        private final String tenantRequestLatencyMetric = "TotalLatencyMs";

        public TenantRequestMetrics(String name, String tenant) {
            this.tags.put("request", name);
            this.tags.put("tenant", tenant);
            this.tenantTotalTimeHist = this.metricsGroup.newHistogram("TotalLatencyMs", true, this.tags);
        }

        public void emitTenantLatencyMetric(Double value) {
            this.tenantTotalTimeHist.update(Math.round(value));
        }

        public void removeTenantLatencyMetric() {
            this.metricsGroup.removeMetric("TotalLatencyMs", this.tags);
        }
    }
}

