/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server;

import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.ApiVersionManager;
import org.apache.kafka.server.BrokerFeatures;
import org.apache.kafka.server.ClientMetricsManager;
import org.apache.kafka.server.common.FinalizedFeatures;

public class DefaultApiVersionManager
implements ApiVersionManager {
    private final ApiMessageType.ListenerType listenerType;
    private final Supplier<Optional<NodeApiVersions>> nodeApiVersionsSupplier;
    private final BrokerFeatures brokerFeatures;
    private final MetadataCache metadataCache;
    private final boolean enableUnstableLastVersion;
    private final Optional<ClientMetricsManager> clientMetricsManager;
    private final ApiMessageType.ApiVisibility apiVisibility;
    private final boolean describeTopicPartitionsEnabled;

    public DefaultApiVersionManager(ApiMessageType.ListenerType listenerType, Supplier<Optional<NodeApiVersions>> nodeApiVersionsSupplier, BrokerFeatures brokerFeatures, MetadataCache metadataCache, boolean enableUnstableLastVersion, ApiMessageType.ApiVisibility apiVisibility, Optional<ClientMetricsManager> clientMetricsManager, boolean describeTopicPartitionsEnabled) {
        this.listenerType = listenerType;
        this.nodeApiVersionsSupplier = nodeApiVersionsSupplier;
        this.brokerFeatures = brokerFeatures;
        this.metadataCache = metadataCache;
        this.enableUnstableLastVersion = enableUnstableLastVersion;
        this.clientMetricsManager = clientMetricsManager;
        this.apiVisibility = apiVisibility;
        this.describeTopicPartitionsEnabled = describeTopicPartitionsEnabled;
    }

    @Override
    public boolean enableUnstableLastVersion() {
        return this.enableUnstableLastVersion;
    }

    @Override
    public ApiMessageType.ApiVisibility apiVisibility() {
        return this.apiVisibility;
    }

    @Override
    public ApiMessageType.ListenerType listenerType() {
        return this.listenerType;
    }

    @Override
    public Set<ApiKeys> enabledApis() {
        return ApiKeys.apisForListener((ApiMessageType.ListenerType)this.listenerType);
    }

    @Override
    public ApiVersionsResponse apiVersionResponse(int throttleTimeMs, boolean alterFeatureLevel0, boolean includeInterBroker) {
        FinalizedFeatures finalizedFeatures = this.metadataCache.features();
        Optional<NodeApiVersions> controllerApiVersions = this.nodeApiVersionsSupplier.get();
        boolean clientTelemetryEnabled = this.clientMetricsManager.map(ClientMetricsManager::isTelemetryReceiverConfigured).orElse(false);
        ApiVersionsResponseData.ApiVersionCollection apiVersions = controllerApiVersions.map(nodeApiVersions -> ApiVersionsResponse.controllerApiVersions((NodeApiVersions)nodeApiVersions, (ApiMessageType.ListenerType)this.listenerType, (boolean)this.enableUnstableLastVersion, (boolean)clientTelemetryEnabled, (ApiMessageType.ApiVisibility)this.apiVisibility, (boolean)this.describeTopicPartitionsEnabled)).orElseGet(() -> ApiVersionsResponse.brokerApiVersions((ApiMessageType.ListenerType)this.listenerType, (boolean)this.enableUnstableLastVersion, (boolean)clientTelemetryEnabled, (ApiMessageType.ApiVisibility)this.apiVisibility, (boolean)this.describeTopicPartitionsEnabled));
        return new ApiVersionsResponse.Builder().setThrottleTimeMs(throttleTimeMs).setApiVersions(this.filterApiVersions(apiVersions, includeInterBroker)).setSupportedFeatures(this.brokerFeatures.supportedFeatures()).setFinalizedFeatures(finalizedFeatures.finalizedFeatures()).setFinalizedFeaturesEpoch(finalizedFeatures.finalizedFeaturesEpoch()).setAlterFeatureLevel0(alterFeatureLevel0).build();
    }

    @Override
    public FinalizedFeatures features() {
        return this.metadataCache.features();
    }
}

