/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.fetch;

import java.util.Objects;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.share.fetch.AcquisitionLockTimerTask;
import org.apache.kafka.server.share.fetch.DeliveryCountOps;
import org.apache.kafka.server.share.fetch.RecordState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InFlightState {
    private static final Logger log = LoggerFactory.getLogger(InFlightState.class);
    private static final String EMPTY_MEMBER_ID = Uuid.ZERO_UUID.toString();
    private RecordState state;
    private int deliveryCount;
    private String memberId;
    private RollbackState rollbackState;
    private AcquisitionLockTimerTask acquisitionLockTimeoutTask;
    private boolean isTerminalState = false;

    public InFlightState(RecordState state, int deliveryCount, String memberId) {
        this(state, deliveryCount, memberId, null);
    }

    InFlightState(RecordState state, int deliveryCount, String memberId, AcquisitionLockTimerTask acquisitionLockTimeoutTask) {
        this.state = state;
        this.deliveryCount = deliveryCount;
        this.memberId = memberId;
        this.acquisitionLockTimeoutTask = acquisitionLockTimeoutTask;
    }

    public RecordState state() {
        return this.state;
    }

    public int deliveryCount() {
        return this.deliveryCount;
    }

    public String memberId() {
        return this.memberId;
    }

    public AcquisitionLockTimerTask acquisitionLockTimeoutTask() {
        return this.acquisitionLockTimeoutTask;
    }

    public void updateAcquisitionLockTimeoutTask(AcquisitionLockTimerTask acquisitionLockTimeoutTask) throws IllegalArgumentException {
        if (this.acquisitionLockTimeoutTask != null) {
            throw new IllegalArgumentException("Existing acquisition lock timeout exists, cannot override.");
        }
        this.acquisitionLockTimeoutTask = acquisitionLockTimeoutTask;
    }

    public void cancelAndClearAcquisitionLockTimeoutTask() {
        if (this.acquisitionLockTimeoutTask != null) {
            this.acquisitionLockTimeoutTask.cancel();
            this.acquisitionLockTimeoutTask = null;
        }
    }

    public boolean hasOngoingStateTransition() {
        return this.rollbackState != null;
    }

    public InFlightState tryUpdateState(RecordState newState, DeliveryCountOps ops, int maxDeliveryCount, String newMemberId) {
        try {
            if (this.hasOngoingStateTransition()) {
                log.info("{} has ongoing state transition, cannot update to: {}", (Object)this, (Object)newState);
                return null;
            }
            if (newState == RecordState.AVAILABLE && ops != DeliveryCountOps.DECREASE && this.deliveryCount >= maxDeliveryCount) {
                newState = RecordState.ARCHIVED;
            }
            this.state = this.state.validateTransition(newState);
            if (newState != RecordState.ARCHIVED) {
                this.deliveryCount = this.updatedDeliveryCount(ops);
            }
            this.memberId = newMemberId;
            return this;
        }
        catch (IllegalStateException e) {
            log.error("Failed to update state of the records", (Throwable)e);
            return null;
        }
    }

    public void archive() {
        this.isTerminalState = true;
        this.state = RecordState.ARCHIVED;
        this.memberId = EMPTY_MEMBER_ID;
        this.cancelAndClearAcquisitionLockTimeoutTask();
    }

    public InFlightState startStateTransition(RecordState newState, DeliveryCountOps ops, int maxDeliveryCount, String newMemberId) {
        InFlightState currentState = new InFlightState(this.state, this.deliveryCount, this.memberId, this.acquisitionLockTimeoutTask);
        InFlightState updatedState = this.tryUpdateState(newState, ops, maxDeliveryCount, newMemberId);
        if (updatedState != null) {
            this.rollbackState = new RollbackState(currentState, maxDeliveryCount);
        }
        return updatedState;
    }

    public void completeStateTransition(boolean commit) {
        if (commit || this.isTerminalState) {
            this.cancelAndClearAcquisitionLockTimeoutTask();
            this.rollbackState = null;
            return;
        }
        InFlightState previousState = this.rollbackState.state();
        if (this.acquisitionLockTimeoutTask != null && this.acquisitionLockTimeoutTask.hasExpired()) {
            this.state = previousState.deliveryCount() >= this.rollbackState.maxDeliveryCount ? RecordState.ARCHIVED : RecordState.AVAILABLE;
            this.memberId = EMPTY_MEMBER_ID;
            this.cancelAndClearAcquisitionLockTimeoutTask();
        } else {
            this.state = previousState.state();
            this.memberId = previousState.memberId();
        }
        this.rollbackState = null;
    }

    private int updatedDeliveryCount(DeliveryCountOps ops) {
        return switch (ops) {
            default -> throw new IncompatibleClassChangeError();
            case DeliveryCountOps.INCREASE -> this.deliveryCount + 1;
            case DeliveryCountOps.DECREASE -> this.deliveryCount - 1;
            case DeliveryCountOps.NO_OP -> this.deliveryCount;
        };
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.deliveryCount, this.memberId});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InFlightState that = (InFlightState)o;
        return this.state == that.state && this.deliveryCount == that.deliveryCount && this.memberId.equals(that.memberId);
    }

    public String toString() {
        return "InFlightState(state=" + this.state.toString() + ", deliveryCount=" + this.deliveryCount + ", memberId=" + this.memberId + ")";
    }

    private record RollbackState(InFlightState state, int maxDeliveryCount) {
    }
}

