/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.quota;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.SimpleRate;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.log.remote.quota.RLMQuotaManagerConfig;
import org.apache.kafka.server.quota.QuotaType;
import org.apache.kafka.server.quota.QuotaUtils;
import org.apache.kafka.server.quota.SensorAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RLMQuotaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RLMQuotaManager.class);
    private final RLMQuotaManagerConfig config;
    private final Metrics metrics;
    private final QuotaType quotaType;
    private final String description;
    private final Time time;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final SensorAccess sensorAccess;
    private Quota quota;

    public RLMQuotaManager(RLMQuotaManagerConfig config, Metrics metrics, QuotaType quotaType, String description, Time time) {
        this.config = config;
        this.metrics = metrics;
        this.quotaType = quotaType;
        this.description = description;
        this.time = time;
        this.quota = new Quota((double)config.quotaBytesPerSecond(), true);
        this.sensorAccess = new SensorAccess((ReadWriteLock)this.lock, metrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateQuota(Quota newQuota) {
        this.lock.writeLock().lock();
        try {
            this.quota = newQuota;
            Map allMetrics = this.metrics.metrics();
            MetricName quotaMetricName = this.metricName();
            KafkaMetric metric = (KafkaMetric)allMetrics.get(quotaMetricName);
            if (metric != null) {
                LOGGER.info("Sensor for quota-id {} already exists. Setting quota to {} in MetricConfig", (Object)quotaMetricName, (Object)newQuota);
                metric.config(this.getQuotaMetricConfig(newQuota));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public long getThrottleTimeMs() {
        Sensor sensorInstance = this.sensor();
        try {
            sensorInstance.checkQuotas();
        }
        catch (QuotaViolationException qve) {
            LOGGER.debug("Quota violated for sensor ({}), metric: ({}), metric-value: ({}), bound: ({})", new Object[]{sensorInstance.name(), qve.metric().metricName(), qve.value(), qve.bound()});
            return QuotaUtils.throttleTime((QuotaViolationException)qve, (long)this.time.milliseconds());
        }
        return 0L;
    }

    public void record(double value) {
        this.sensor().record(value, this.time.milliseconds(), false);
    }

    private MetricConfig getQuotaMetricConfig(Quota quota) {
        return new MetricConfig().timeWindow((long)this.config.quotaWindowSizeSeconds(), TimeUnit.SECONDS).samples(this.config.numQuotaSamples()).quota(quota);
    }

    private MetricName metricName() {
        return this.metrics.metricName("byte-rate", this.quotaType.toString(), this.description, Map.of());
    }

    private Sensor sensor() {
        return this.sensorAccess.getOrCreate(this.quotaType.toString(), 3600L, sensor -> sensor.add(this.metricName(), (MeasurableStat)new SimpleRate(), this.getQuotaMetricConfig(this.quota)));
    }
}

