/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.durability.restore.db.serdes;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import io.confluent.kafka.durability.restore.db.serdes.PartitionRestoreContext;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class Job
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_25_2_10();
    }

    public static Job getRootAsJob(ByteBuffer _bb) {
        return Job.getRootAsJob(_bb, new Job());
    }

    public static Job getRootAsJob(ByteBuffer _bb, Job obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public Job __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public int id() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public int status() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public long startTime() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public long endTime() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public PartitionRestoreContext partitionRestoreContexts(int j) {
        return this.partitionRestoreContexts(new PartitionRestoreContext(), j);
    }

    public PartitionRestoreContext partitionRestoreContexts(PartitionRestoreContext obj, int j) {
        int o = this.__offset(12);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int partitionRestoreContextsLength() {
        int o = this.__offset(12);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public PartitionRestoreContext.Vector partitionRestoreContextsVector() {
        return this.partitionRestoreContextsVector(new PartitionRestoreContext.Vector());
    }

    public PartitionRestoreContext.Vector partitionRestoreContextsVector(PartitionRestoreContext.Vector obj) {
        int o = this.__offset(12);
        return o != 0 ? obj.__assign(this.__vector(o), 4, this.bb) : null;
    }

    public static int createJob(FlatBufferBuilder builder, int id, int status, long startTime, long endTime, int partitionRestoreContextsOffset) {
        builder.startTable(5);
        Job.addEndTime(builder, endTime);
        Job.addStartTime(builder, startTime);
        Job.addPartitionRestoreContexts(builder, partitionRestoreContextsOffset);
        Job.addStatus(builder, status);
        Job.addId(builder, id);
        return Job.endJob(builder);
    }

    public static void startJob(FlatBufferBuilder builder) {
        builder.startTable(5);
    }

    public static void addId(FlatBufferBuilder builder, int id) {
        builder.addInt(0, id, 0);
    }

    public static void addStatus(FlatBufferBuilder builder, int status) {
        builder.addInt(1, status, 0);
    }

    public static void addStartTime(FlatBufferBuilder builder, long startTime) {
        builder.addLong(2, startTime, 0L);
    }

    public static void addEndTime(FlatBufferBuilder builder, long endTime) {
        builder.addLong(3, endTime, 0L);
    }

    public static void addPartitionRestoreContexts(FlatBufferBuilder builder, int partitionRestoreContextsOffset) {
        builder.addOffset(4, partitionRestoreContextsOffset, 0);
    }

    public static int createPartitionRestoreContextsVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startPartitionRestoreContextsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endJob(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public Job get(int j) {
            return this.get(new Job(), j);
        }

        public Job get(Job obj, int j) {
            return obj.__assign(Job.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

