/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.tier.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.kafka.storage.internals.utils.Throttler;

public class ThrottledFileInputStream
extends FileInputStream {
    private final Throttler throttler;

    public ThrottledFileInputStream(File file, Throttler throttler) throws FileNotFoundException {
        super(file);
        this.throttler = throttler;
    }

    @Override
    public int read() throws IOException {
        int next = super.read();
        if (next >= 0) {
            this.throttler.maybeThrottle(1.0);
        }
        return next;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int n = super.read(b);
        if (n > 0) {
            this.throttler.maybeThrottle(n);
        }
        return n;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = super.read(b, off, len);
        if (n > 0) {
            this.throttler.maybeThrottle(n);
        }
        return n;
    }
}

