/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;

public class LogCleanerMetrics {
    private final String pkg = "kafka.log";
    private final Optional<String> form;
    private MetricName offsetIndexBytesPerSecMetricName;
    private MetricName offsetMapFilledRateMetricName;
    private MetricName bytesReadPerSecMetricName;
    private MetricName bytesWrittenPerSecMetricName;
    private MetricName validationPassedMetricName;
    private MetricName validationAbortedMetricName;
    private MetricName validationFailedMetricName;
    public Meter offsetIndexBytesPerSec;
    public Meter offsetMapFilledRatePerSec;
    public Meter bytesReadPerSec;
    public Meter bytesWrittenPerSec;
    public Meter validationPassedPerSec;
    public Meter validationAbortedPerSec;
    public Meter validationFailedPerSec;
    private MetricName maxCompactionDelayMetricName;
    private MetricName cleanablePartitionsCleanBytesLastRunMetricName;
    private MetricName cleanablePartitionsCleanableBytesLastRunMetricName;
    private MetricName cleanablePartitionsUncleanableBytesLastRunMetricName;
    private MetricName maxBufferUtilizationPercentMetricName;
    private MetricName compactionCpuUtilizationPercentMetricName;
    private MetricName cleanerRecopyPercentMetricName;
    private MetricName maxDirtyPercentMetricName;

    public void setMaxCompactionDelayGauge(Gauge<Long> metric) {
        KafkaYammerMetrics.defaultRegistry().newGauge(this.maxCompactionDelayMetricName, metric);
    }

    public void setCleanablePartitionsCleanBytesLastRunGauge(Gauge<Long> metric) {
        KafkaYammerMetrics.defaultRegistry().newGauge(this.cleanablePartitionsCleanBytesLastRunMetricName, metric);
    }

    public void setCleanablePartitionsCleanableBytesLastRunGauge(Gauge<Long> metric) {
        KafkaYammerMetrics.defaultRegistry().newGauge(this.cleanablePartitionsCleanableBytesLastRunMetricName, metric);
    }

    public void setCleanablePartitionsUncleanableBytesLastRunGauge(Gauge<Long> metric) {
        KafkaYammerMetrics.defaultRegistry().newGauge(this.cleanablePartitionsUncleanableBytesLastRunMetricName, metric);
    }

    public void setMaxBufferUtilizationPercentGauge(Gauge<Integer> metric) {
        KafkaYammerMetrics.defaultRegistry().newGauge(this.maxBufferUtilizationPercentMetricName, metric);
    }

    public void setCompactionCpuUtilizationPercentGauge(Gauge<Double> metric) {
        KafkaYammerMetrics.defaultRegistry().newGauge(this.compactionCpuUtilizationPercentMetricName, metric);
    }

    public void setCleanerRecopyPercentGauge(Gauge<Integer> metric) {
        KafkaYammerMetrics.defaultRegistry().newGauge(this.cleanerRecopyPercentMetricName, metric);
    }

    public void setMaxDirtyPercentGauge(Gauge<Integer> metric) {
        KafkaYammerMetrics.defaultRegistry().newGauge(this.maxDirtyPercentMetricName, metric);
    }

    public LogCleanerMetrics() {
        this.form = Optional.empty();
        this.initializeMetrics();
    }

    public LogCleanerMetrics(Optional<String> form) {
        this.form = form;
        this.initializeMetrics();
    }

    private void initializeMetrics() {
        this.offsetIndexBytesPerSecMetricName = KafkaMetricsGroup.explicitMetricName((String)"kafka.log", (String)"CleanerStats", (String)"CompactionOffsetMapThroughputBytesPerSec", this.getTags(Map.of("op", "read")));
        this.offsetMapFilledRateMetricName = KafkaMetricsGroup.explicitMetricName((String)"kafka.log", (String)"CleanerStats", (String)"CompactionOffsetMapFilledRatePerSec", this.getTags(Map.of()));
        this.bytesReadPerSecMetricName = KafkaMetricsGroup.explicitMetricName((String)"kafka.log", (String)"CleanerStats", (String)"CompactionThroughputBytesPerSec", this.getTags(Map.of("op", "read")));
        this.bytesWrittenPerSecMetricName = KafkaMetricsGroup.explicitMetricName((String)"kafka.log", (String)"CleanerStats", (String)"CompactionThroughputBytesPerSec", this.getTags(Map.of("op", "write")));
        this.validationPassedMetricName = KafkaMetricsGroup.explicitMetricName((String)"kafka.log", (String)"CleanerStats", (String)"CompactionValidationPassedPerSec", this.getTags(Map.of()));
        this.validationAbortedMetricName = KafkaMetricsGroup.explicitMetricName((String)"kafka.log", (String)"CleanerStats", (String)"CompactionValidationAbortedPerSec", this.getTags(Map.of()));
        this.validationFailedMetricName = KafkaMetricsGroup.explicitMetricName((String)"kafka.log", (String)"CleanerStats", (String)"CompactionValidationFailedPerSec", this.getTags(Map.of()));
        this.offsetIndexBytesPerSec = KafkaYammerMetrics.defaultRegistry().newMeter(this.offsetIndexBytesPerSecMetricName, "bytes", TimeUnit.SECONDS);
        this.offsetMapFilledRatePerSec = KafkaYammerMetrics.defaultRegistry().newMeter(this.offsetMapFilledRateMetricName, "number of times offset map was filled per second", TimeUnit.SECONDS);
        this.bytesReadPerSec = KafkaYammerMetrics.defaultRegistry().newMeter(this.bytesReadPerSecMetricName, "bytes", TimeUnit.SECONDS);
        this.bytesWrittenPerSec = KafkaYammerMetrics.defaultRegistry().newMeter(this.bytesWrittenPerSecMetricName, "bytes", TimeUnit.SECONDS);
        this.validationPassedPerSec = KafkaYammerMetrics.defaultRegistry().newMeter(this.validationPassedMetricName, "number of times compaction validation passed per second", TimeUnit.SECONDS);
        this.validationAbortedPerSec = KafkaYammerMetrics.defaultRegistry().newMeter(this.validationAbortedMetricName, "number of times compaction validation aborted per second", TimeUnit.SECONDS);
        this.validationFailedPerSec = KafkaYammerMetrics.defaultRegistry().newMeter(this.validationFailedMetricName, "number of times compaction validation failed per second", TimeUnit.SECONDS);
        this.maxCompactionDelayMetricName = KafkaMetricsGroup.explicitMetricName((String)"kafka.log", (String)"LogCleaner", (String)"max-compaction-delay-secs", this.getTags(Map.of()));
        this.cleanablePartitionsCleanBytesLastRunMetricName = KafkaMetricsGroup.explicitMetricName((String)"kafka.log", (String)"LogCleaner", (String)"cleanable-partitions-clean-bytes-last-run", this.getTags(Map.of()));
        this.cleanablePartitionsCleanableBytesLastRunMetricName = KafkaMetricsGroup.explicitMetricName((String)"kafka.log", (String)"LogCleaner", (String)"cleanable-partitions-cleanable-bytes-last-run", this.getTags(Map.of()));
        this.cleanablePartitionsUncleanableBytesLastRunMetricName = KafkaMetricsGroup.explicitMetricName((String)"kafka.log", (String)"LogCleaner", (String)"cleanable-partitions-uncleanable-bytes-last-run", this.getTags(Map.of()));
        this.maxBufferUtilizationPercentMetricName = KafkaMetricsGroup.explicitMetricName((String)"kafka.log", (String)"LogCleaner", (String)"max-buffer-utilization-percent", this.getTags(Map.of()));
        this.compactionCpuUtilizationPercentMetricName = KafkaMetricsGroup.explicitMetricName((String)"kafka.log", (String)"LogCleaner", (String)"compaction-cpu-utilization-percent", this.getTags(Map.of()));
        this.cleanerRecopyPercentMetricName = KafkaMetricsGroup.explicitMetricName((String)"kafka.log", (String)"LogCleaner", (String)"cleaner-recopy-percent", this.getTags(Map.of()));
        this.maxDirtyPercentMetricName = KafkaMetricsGroup.explicitMetricName((String)"kafka.log", (String)"LogCleanerManager", (String)"max-dirty-percent", this.getTags(Map.of()));
    }

    private Map<String, String> getTags(Map<String, String> tags) {
        HashMap<String, String> result = new HashMap<String, String>(tags);
        result.put("form", this.form.orElse(""));
        return result;
    }
}

