/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import io.confluent.kafka.storage.log.AbstractLog;
import io.confluent.kafka.storage.log.CleanParams;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.storage.internals.log.LogCleanerManager;
import org.apache.kafka.storage.internals.log.LogSegment;

public final class LogToClean
implements Comparable<LogToClean>,
CleanParams {
    private final TopicPartition topicPartition;
    private final AbstractLog log;
    private final long firstDirtyOffset;
    private final boolean needCompactionNow;
    private final long cleanBytes;
    private final long firstUncleanableOffset;
    private final long cleanableBytes;
    private final long totalBytes;
    private final double cleanableRatio;
    private final long uncleanableBytes;
    private final long startOffset = 0L;

    public LogToClean(AbstractLog log, long firstDirtyOffset, long uncleanableOffset, boolean needCompactionNow) {
        this.log = log;
        this.topicPartition = log.topicPartition();
        this.firstDirtyOffset = firstDirtyOffset;
        this.needCompactionNow = needCompactionNow;
        this.cleanBytes = log.localLogSegments(0L, firstDirtyOffset).stream().mapToLong(LogSegment::size).sum();
        Map.Entry<Long, Long> cleanableBytesResult = LogCleanerManager.calculateCleanableBytes(log, firstDirtyOffset, uncleanableOffset);
        this.firstUncleanableOffset = cleanableBytesResult.getKey();
        this.cleanableBytes = cleanableBytesResult.getValue();
        this.totalBytes = this.cleanBytes + this.cleanableBytes;
        this.cleanableRatio = (double)this.cleanableBytes / (double)this.totalBytes;
        this.uncleanableBytes = log.sizeDetails().localSize() - this.totalBytes;
    }

    @Override
    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    @Override
    public Optional<TopicIdPartition> topicIdPartition() {
        return this.log.topicIdPartition();
    }

    @Override
    public AbstractLog log() {
        return this.log;
    }

    @Override
    public long firstDirtyOffset() {
        return this.firstDirtyOffset;
    }

    public boolean needCompactionNow() {
        return this.needCompactionNow;
    }

    public long cleanBytes() {
        return this.cleanBytes;
    }

    @Override
    public long firstUncleanableOffset() {
        return this.firstUncleanableOffset;
    }

    public long cleanableBytes() {
        return this.cleanableBytes;
    }

    public long totalBytes() {
        return this.totalBytes;
    }

    public double cleanableRatio() {
        return this.cleanableRatio;
    }

    public long uncleanableBytes() {
        return this.uncleanableBytes;
    }

    @Override
    public long startOffset() {
        return 0L;
    }

    @Override
    public int compareTo(LogToClean that) {
        return Double.compare(this.cleanableRatio, that.cleanableRatio);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogToClean that = (LogToClean)o;
        return this.firstDirtyOffset == that.firstDirtyOffset && this.needCompactionNow == that.needCompactionNow && this.cleanBytes == that.cleanBytes && this.firstUncleanableOffset == that.firstUncleanableOffset && this.cleanableBytes == that.cleanableBytes && this.totalBytes == that.totalBytes && this.uncleanableBytes == that.uncleanableBytes && Double.compare(that.cleanableRatio, this.cleanableRatio) == 0 && this.topicPartition.equals((Object)that.topicPartition) && this.log.equals(that.log);
    }

    public int hashCode() {
        return Objects.hash(this.topicPartition, this.log, this.firstDirtyOffset, this.needCompactionNow, this.cleanBytes, this.firstUncleanableOffset, this.cleanableBytes, this.totalBytes, this.cleanableRatio, this.uncleanableBytes);
    }

    public String toString() {
        return "LogToClean{topicPartition=" + String.valueOf(this.topicPartition) + ", log=" + String.valueOf(this.log) + ", firstDirtyOffset=" + this.firstDirtyOffset + ", needCompactionNow=" + this.needCompactionNow + ", cleanBytes=" + this.cleanBytes + ", firstUncleanableOffset=" + this.firstUncleanableOffset + ", cleanableBytes=" + this.cleanableBytes + ", totalBytes=" + this.totalBytes + ", cleanableRatio=" + this.cleanableRatio + ", uncleanableBytes=" + this.uncleanableBytes + "}";
    }
}

