/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.TieredFragmentType;
import org.apache.kafka.common.message.ResolveOffsetRangeResponseData;
import org.apache.kafka.common.protocol.Errors;

public final class ResolvedOffsetRanges {
    public static final ResolvedOffsetRanges EMPTY = new ResolvedOffsetRanges(List.of());
    private final Optional<Exception> responseException;
    private final List<TieredRange> tieredRanges;
    private final long firstUntieredOffset;
    private final long lastReadableOffset;

    public ResolvedOffsetRanges(List<TieredRange> tieredRanges) {
        this(tieredRanges, -1L, -1L, Optional.empty());
    }

    public ResolvedOffsetRanges(List<TieredRange> tieredRanges, long firstUntieredOffset, long lastReadableOffset) {
        this(tieredRanges, firstUntieredOffset, lastReadableOffset, Optional.empty());
    }

    public ResolvedOffsetRanges(Exception e) {
        this(List.of(), -1L, -1L, Optional.of(e));
    }

    private ResolvedOffsetRanges(List<TieredRange> tieredRanges, long firstUntieredOffset, long lastReadableOffset, Optional<Exception> exception) {
        this.tieredRanges = tieredRanges;
        this.firstUntieredOffset = firstUntieredOffset;
        this.lastReadableOffset = lastReadableOffset;
        this.responseException = exception;
    }

    public Optional<Exception> responseException() {
        return this.responseException;
    }

    public List<TieredRange> tieredRanges() {
        return this.tieredRanges;
    }

    public long firstUntieredOffset() {
        return this.firstUntieredOffset;
    }

    public long lastReadableOffset() {
        return this.lastReadableOffset;
    }

    public ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse toResponse(int partitionId) {
        if (this.responseException.isPresent()) {
            return new ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse().setPartitionIndex(partitionId).setErrorCode(Errors.forException((Throwable)this.responseException.get()).code()).setErrorMessage(this.responseException.get().getMessage()).setTieredSegmentRange(null).setBrokerRange(null);
        }
        return new ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse().setPartitionIndex(partitionId).setErrorCode(Errors.NONE.code()).setBrokerRange(this.firstUntieredOffset == -1L ? null : new ResolveOffsetRangeResponseData.BrokerMetadata().setStartOffset(this.firstUntieredOffset).setEndOffset(this.lastReadableOffset)).setTieredSegmentRange(this.tieredRanges.stream().map(TieredRange::toResponse).collect(Collectors.toList()));
    }

    public static class TieredRange {
        private final long startOffset;
        private final long endOffset;
        private final TieredObject dataSegment;
        private final TieredObject offsetIndex;
        private final Optional<TieredObject> abortedTransactionIndex;

        public TieredRange(long startOffset, long endOffset, TieredObject dataSegment, TieredObject offsetIndex) {
            this(startOffset, endOffset, dataSegment, offsetIndex, Optional.empty());
        }

        public TieredRange(long startOffset, long endOffset, TieredObject dataSegment, TieredObject offsetIndex, Optional<TieredObject> transactionIndex) {
            this.validateTieredObjects(dataSegment, offsetIndex, transactionIndex);
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.dataSegment = dataSegment;
            this.offsetIndex = offsetIndex;
            this.abortedTransactionIndex = transactionIndex;
        }

        private void validateTieredObjects(TieredObject dataSegment, TieredObject offsetIndex, Optional<TieredObject> transactionIndex) {
            if (dataSegment.fragmentType != TieredFragmentType.SEGMENT) {
                throw new IllegalArgumentException("Data segment must be of type SEGMENT");
            }
            if (offsetIndex.fragmentType != TieredFragmentType.OFFSET_INDEX) {
                throw new IllegalArgumentException("Offset index must be of type OFFSET_INDEX");
            }
            if (transactionIndex.isPresent() && transactionIndex.get().fragmentType != TieredFragmentType.TRANSACTION_INDEX) {
                throw new IllegalArgumentException("Transaction index must be of type TRANSACTION_INDEX");
            }
        }

        public long startOffset() {
            return this.startOffset;
        }

        public long endOffset() {
            return this.endOffset;
        }

        public TieredObject dataSegment() {
            return this.dataSegment;
        }

        public TieredObject offsetIndex() {
            return this.offsetIndex;
        }

        public Optional<TieredObject> abortedTransactionIndex() {
            return this.abortedTransactionIndex;
        }

        public ResolveOffsetRangeResponseData.TieredSegmentMetadata toResponse() {
            ResolveOffsetRangeResponseData.TieredSegmentMetadata response = new ResolveOffsetRangeResponseData.TieredSegmentMetadata().setStartOffset(this.startOffset).setEndOffset(this.endOffset);
            ArrayList<ResolveOffsetRangeResponseData.SegmentFileMetadata> files = new ArrayList<ResolveOffsetRangeResponseData.SegmentFileMetadata>();
            files.add(this.dataSegment.toResponse());
            files.add(this.offsetIndex.toResponse());
            this.abortedTransactionIndex.ifPresent(transactionIndex -> files.add(transactionIndex.toResponse()));
            response.setSegmentFiles(files);
            return response;
        }

        public static final class TieredObject {
            private final String locator;
            private final int startPosition;
            private final int endPosition;
            private final TieredFragmentType fragmentType;

            public TieredObject(String locator, int startPosition, int endPosition, TieredFragmentType fragmentType) {
                this.locator = locator;
                this.startPosition = startPosition;
                this.endPosition = endPosition;
                this.fragmentType = fragmentType;
            }

            public ResolveOffsetRangeResponseData.SegmentFileMetadata toResponse() {
                return new ResolveOffsetRangeResponseData.SegmentFileMetadata().setLocator(this.locator).setStartBytePosition((long)this.startPosition).setEndBytePosition((long)this.endPosition).setFragmentTypeByte(this.fragmentType.getByte());
            }

            public String locator() {
                return this.locator;
            }

            public int startPosition() {
                return this.startPosition;
            }

            public int endPosition() {
                return this.endPosition;
            }

            public TieredFragmentType fragmentType() {
                return this.fragmentType;
            }
        }
    }
}

