/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.List;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class ThrottledReplicaListValidator
implements ConfigDef.Validator {
    public static final String ALL_THROTTLED_REPLICAS_VALUE = "*";
    public static final String NO_THROTTLED_REPLICAS_VALUE = "none";
    public static final ConfigDef.Validator INSTANCE = new ThrottledReplicaListValidator();

    private ThrottledReplicaListValidator() {
    }

    public static void ensureValidString(String name, String value) {
        INSTANCE.ensureValid(name, List.of(value.split(",")));
    }

    public void ensureValid(String name, Object value) {
        if (value instanceof List) {
            List<String> proposed = ((List)value).stream().map(element -> element.toString().trim()).toList();
            String proposedString = String.join((CharSequence)"", proposed);
            if (!(proposed.stream().allMatch(s -> s.matches("([0-9]+:[0-9]+)?")) || proposedString.equals(ALL_THROTTLED_REPLICAS_VALUE) || proposedString.equals(NO_THROTTLED_REPLICAS_VALUE))) {
                throw new ConfigException(name, value, name + " must be the literal '*', 'none' or a list of replicas in the following format: [partitionId]:[brokerId],[partitionId]:[brokerId],...");
            }
        } else {
            throw new ConfigException(name, value, name + " must be a List but was " + value.getClass().getName());
        }
    }

    public String toString() {
        return "[partitionId]:[brokerId],[partitionId]:[brokerId],...";
    }
}

