/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.concurrent.atomic.AtomicLong;

public final class VerificationGuard {
    public static final VerificationGuard SENTINEL = new VerificationGuard(0L);
    private static final AtomicLong INCREMENTING_ID = new AtomicLong(0L);
    private final long value;

    public VerificationGuard() {
        this.value = INCREMENTING_ID.incrementAndGet();
    }

    private VerificationGuard(long value) {
        this.value = value;
    }

    public String toString() {
        return "VerificationGuard(value=" + this.value + ")";
    }

    public boolean equals(Object obj) {
        if (null == obj || obj.getClass() != this.getClass()) {
            return false;
        }
        VerificationGuard guard = (VerificationGuard)obj;
        return this.value == guard.value();
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    private long value() {
        return this.value;
    }

    public boolean verify(VerificationGuard verifyingGuard) {
        return verifyingGuard != SENTINEL && verifyingGuard.equals(this);
    }
}

