/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.durability.db.serdes;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import io.confluent.kafka.storage.tier.serdes.UUID;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class AuditRunInfo
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_25_2_10();
    }

    public static AuditRunInfo getRootAsAuditRunInfo(ByteBuffer _bb) {
        return AuditRunInfo.getRootAsAuditRunInfo(_bb, new AuditRunInfo());
    }

    public static AuditRunInfo getRootAsAuditRunInfo(ByteBuffer _bb, AuditRunInfo obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public AuditRunInfo __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public long readTierPartitionOffset() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public int auditTimeNsPerRecord() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public String auditId() {
        int o = this.__offset(8);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer auditIdAsByteBuffer() {
        return this.__vector_as_bytebuffer(8, 1);
    }

    public ByteBuffer auditIdInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 8, 1);
    }

    public int failedAttempts() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public UUID validatedObjectIds(int j) {
        return this.validatedObjectIds(new UUID(), j);
    }

    public UUID validatedObjectIds(UUID obj, int j) {
        int o = this.__offset(12);
        return o != 0 ? obj.__assign(this.__vector(o) + j * 16, this.bb) : null;
    }

    public int validatedObjectIdsLength() {
        int o = this.__offset(12);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public UUID.Vector validatedObjectIdsVector() {
        return this.validatedObjectIdsVector(new UUID.Vector());
    }

    public UUID.Vector validatedObjectIdsVector(UUID.Vector obj) {
        int o = this.__offset(12);
        return o != 0 ? obj.__assign(this.__vector(o), 16, this.bb) : null;
    }

    public static int createAuditRunInfo(FlatBufferBuilder builder, long readTierPartitionOffset, int auditTimeNsPerRecord, int auditIdOffset, int failedAttempts, int validatedObjectIdsOffset) {
        builder.startTable(5);
        AuditRunInfo.addReadTierPartitionOffset(builder, readTierPartitionOffset);
        AuditRunInfo.addValidatedObjectIds(builder, validatedObjectIdsOffset);
        AuditRunInfo.addFailedAttempts(builder, failedAttempts);
        AuditRunInfo.addAuditId(builder, auditIdOffset);
        AuditRunInfo.addAuditTimeNsPerRecord(builder, auditTimeNsPerRecord);
        return AuditRunInfo.endAuditRunInfo(builder);
    }

    public static void startAuditRunInfo(FlatBufferBuilder builder) {
        builder.startTable(5);
    }

    public static void addReadTierPartitionOffset(FlatBufferBuilder builder, long readTierPartitionOffset) {
        builder.addLong(0, readTierPartitionOffset, 0L);
    }

    public static void addAuditTimeNsPerRecord(FlatBufferBuilder builder, int auditTimeNsPerRecord) {
        builder.addInt(1, auditTimeNsPerRecord, 0);
    }

    public static void addAuditId(FlatBufferBuilder builder, int auditIdOffset) {
        builder.addOffset(2, auditIdOffset, 0);
    }

    public static void addFailedAttempts(FlatBufferBuilder builder, int failedAttempts) {
        builder.addInt(3, failedAttempts, 0);
    }

    public static void addValidatedObjectIds(FlatBufferBuilder builder, int validatedObjectIdsOffset) {
        builder.addOffset(4, validatedObjectIdsOffset, 0);
    }

    public static void startValidatedObjectIdsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(16, numElems, 8);
    }

    public static int endAuditRunInfo(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public AuditRunInfo get(int j) {
            return this.get(new AuditRunInfo(), j);
        }

        public AuditRunInfo get(AuditRunInfo obj, int j) {
            return obj.__assign(AuditRunInfo.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

