/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.log;

import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.domain.TierObjectMetadata;
import io.confluent.kafka.storage.tier.domain.TierUploadType;
import io.confluent.kafka.storage.tier.fetcher.TierFetchDataInfo;
import io.confluent.kafka.storage.tier.fetcher.TierFetchMetadata;
import io.confluent.kafka.storage.tier.state.SegmentAndMetadataLayout;
import io.confluent.kafka.storage.tier.state.SegmentState;
import io.confluent.kafka.storage.tier.store.objects.FragmentType;
import io.confluent.kafka.storage.tier.store.objects.ObjectType;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public class TierLogSegment {
    private final TopicIdPartition topicIdPartition;
    private final SegmentState segment;
    private final ObjectMetadata metadata;

    public TierLogSegment(TopicIdPartition topicIdPartition, SegmentState segment) {
        this.topicIdPartition = Objects.requireNonNull(topicIdPartition);
        this.segment = Objects.requireNonNull(segment);
        this.metadata = new ObjectMetadata(topicIdPartition, segment);
    }

    public ObjectMetadata metadata() {
        return this.metadata;
    }

    public long baseOffset() {
        return this.segment.baseOffset();
    }

    public long objectBaseOffset() {
        return this.segment.keyBaseOffset();
    }

    public long endOffset() {
        return this.segment.endOffset();
    }

    public int size() {
        return this.segment.size();
    }

    public TierObjectMetadata.State state() {
        return this.segment.state();
    }

    public UUID objectId() {
        return this.metadata.objectId();
    }

    public long nextOffset() {
        return this.segment.endOffset() + 1L;
    }

    public long firstBatchTimestamp() {
        return this.segment.firstBatchTimestamp();
    }

    public long maxTimestamp() {
        return this.segment.maxTimestamp();
    }

    public TierUploadType uploadType() {
        return this.segment.uploadType();
    }

    public Optional<SegmentAndMetadataLayout> segmentAndMetadataLayout() {
        return this.segment.segmentAndMetadataLayout();
    }

    public Optional<Integer> objectSize(FragmentType fragmentType) {
        return this.segmentAndMetadataLayout().flatMap(layout -> this.metadata.objectTypeForFragment(fragmentType).flatMap(objectType -> {
            if (objectType == ObjectType.SEGMENT_WITH_METADATA) {
                int sum = layout.fragmentDescriptionsList().stream().mapToInt(desc -> desc.size()).sum();
                return Optional.of(sum);
            }
            return layout.getSegmentFragmentDescription(fragmentType).map(desc -> desc.size());
        }));
    }

    public TierFetchDataInfo read(long startOffset, int maxSize, long maxPosition, boolean minOneMessage) {
        int maximumReadableBytes = Math.min(maxSize, this.segment.size());
        TierFetchMetadata fetchMetadata = new TierFetchMetadata(this.topicIdPartition.topicPartition(), startOffset, maximumReadableBytes, maxPosition, minOneMessage, this.metadata, Optional.empty(), this.baseOffset(), this.size());
        return new TierFetchDataInfo(fetchMetadata, Optional.empty());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TierLogSegment that = (TierLogSegment)o;
        return this.topicIdPartition.equals(that.topicIdPartition) && this.segment.equals(that.segment);
    }

    public int hashCode() {
        return Objects.hash(this.topicIdPartition, this.segment);
    }

    public String toString() {
        Date maxTimestampFormatted = new Date(this.maxTimestamp());
        return String.format("TierLogSegment(topicPartition: %s, baseOffset: %d, endOffset: %d, maxTimestamp: %d, maxTimestampFormatted: %s, objectBaseOffset: %d, metadata: %s)", this.topicIdPartition, this.baseOffset(), this.endOffset(), this.maxTimestamp(), maxTimestampFormatted, this.objectBaseOffset(), this.metadata);
    }
}

