/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.domain.AbstractTierMetadata;
import io.confluent.kafka.storage.tier.domain.TierRecordType;
import io.confluent.kafka.storage.tier.serdes.MetadataSnapshotUploadInitiate;
import io.confluent.kafka.storage.tier.serdes.OffsetAndEpoch;
import java.nio.ByteBuffer;
import java.util.UUID;

public class TierMetadataSnapshotUploadInitiate
extends AbstractTierMetadata {
    public static final byte VERSION_V1 = 1;
    public static final byte CURRENT_VERSION = 1;
    private static final int INITIAL_BUFFER_SIZE = 72;
    private final TopicIdPartition topicIdPartition;
    protected final MetadataSnapshotUploadInitiate metadata;

    public TierMetadataSnapshotUploadInitiate(TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, io.confluent.kafka.storage.tier.state.OffsetAndEpoch stateOffset, int brokerId) {
        FlatBufferBuilder builder = new FlatBufferBuilder(TierMetadataSnapshotUploadInitiate.initialBufferSize()).forceDefaults(false);
        int entryId = TierMetadataSnapshotUploadInitiate.buildMetadataSnapshotInitiate(builder, tierEpoch, objectId, stateOffset, brokerId);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = MetadataSnapshotUploadInitiate.getRootAsMetadataSnapshotUploadInitiate(builder.dataBuffer());
    }

    public TierMetadataSnapshotUploadInitiate(TopicIdPartition topicIdPartition, MetadataSnapshotUploadInitiate metadata) {
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    static int buildMetadataSnapshotInitiate(FlatBufferBuilder builder, int tierEpoch, UUID objectId, io.confluent.kafka.storage.tier.state.OffsetAndEpoch stateOffset, int brokerId) {
        MetadataSnapshotUploadInitiate.startMetadataSnapshotUploadInitiate(builder);
        MetadataSnapshotUploadInitiate.addVersion(builder, (byte)1);
        MetadataSnapshotUploadInitiate.addTierEpoch(builder, tierEpoch);
        int objectIdOffset = io.confluent.kafka.storage.tier.serdes.UUID.createUUID(builder, objectId.getMostSignificantBits(), objectId.getLeastSignificantBits());
        MetadataSnapshotUploadInitiate.addObjectId(builder, objectIdOffset);
        int offsetAndEpochId = OffsetAndEpoch.createOffsetAndEpoch(builder, stateOffset.offset(), stateOffset.epoch().orElse(-1));
        MetadataSnapshotUploadInitiate.addStateOffsetAndEpoch(builder, offsetAndEpochId);
        MetadataSnapshotUploadInitiate.addBrokerId(builder, brokerId);
        return MetadataSnapshotUploadInitiate.endMetadataSnapshotUploadInitiate(builder);
    }

    public static int initialBufferSize() {
        return 72;
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.MetadataSnapshotUploadInitiate;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public int tierEpoch() {
        return this.metadata.tierEpoch();
    }

    @Override
    public io.confluent.kafka.storage.tier.state.OffsetAndEpoch stateOffsetAndEpoch() {
        return this.metadata.stateOffsetAndEpoch() == null ? io.confluent.kafka.storage.tier.state.OffsetAndEpoch.EMPTY : new io.confluent.kafka.storage.tier.state.OffsetAndEpoch(this.metadata.stateOffsetAndEpoch());
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public UUID messageId() {
        io.confluent.kafka.storage.tier.serdes.UUID objectId = this.metadata.objectId();
        return new UUID(objectId.mostSignificantBits(), objectId.leastSignificantBits());
    }

    public int brokerId() {
        return this.metadata.brokerId();
    }

    public String toString() {
        return "MetadataSnapshotUploadInitiate(version=" + this.metadata.version() + ", topicIdPartition=" + String.valueOf(this.topicIdPartition()) + ", tierEpoch=" + this.tierEpoch() + ", snapshotId=" + String.valueOf(this.messageId()) + ", messageIdBase64=" + this.messageIdAsBase64() + ", stateOffsetAndEpoch=" + String.valueOf(this.stateOffsetAndEpoch()) + ", brokerId=" + this.brokerId() + ")";
    }
}

