/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.domain.AbstractTierSegmentMetadata;
import io.confluent.kafka.storage.tier.domain.TierObjectMetadata;
import io.confluent.kafka.storage.tier.domain.TierRecordType;
import io.confluent.kafka.storage.tier.domain.TierUploadType;
import io.confluent.kafka.storage.tier.exception.TierMetadataDeserializationException;
import io.confluent.kafka.storage.tier.serdes.FragmentDescription;
import io.confluent.kafka.storage.tier.serdes.OffsetAndEpoch;
import io.confluent.kafka.storage.tier.serdes.OpaqueDataField;
import io.confluent.kafka.storage.tier.serdes.SegmentUploadInitiate;
import io.confluent.kafka.storage.tier.state.SegmentAndMetadataLayout;
import io.confluent.kafka.storage.tier.store.OpaqueData;
import io.confluent.kafka.storage.tier.store.objects.FragmentDescriptionWrapper;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public class TierSegmentUploadInitiate
extends AbstractTierSegmentMetadata {
    public static final byte VERSION_V1 = 1;
    public static final byte VERSION_V2 = 2;
    public static final byte VERSION_V3 = 3;
    public static final byte VERSION_V4 = 4;
    public static final byte CURRENT_VERSION = 4;
    private static final int INITIAL_BUFFER_SIZE = 160;
    private final TopicIdPartition topicIdPartition;
    private final SegmentUploadInitiate metadata;

    public TierSegmentUploadInitiate(TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, long baseOffset, long endOffset, long maxTimestamp, long firstBatchTimestamp, int size, boolean hasEpochState, boolean hasAbortedTxns, boolean hasProducerState, TierUploadType uploadType, io.confluent.kafka.storage.tier.state.OffsetAndEpoch stateOffset, OpaqueData opaqueData) {
        this(topicIdPartition, tierEpoch, objectId, Optional.empty(), baseOffset, endOffset, maxTimestamp, firstBatchTimestamp, size, hasEpochState, hasAbortedTxns, hasProducerState, uploadType, stateOffset, opaqueData, Optional.empty(), Optional.empty());
    }

    public TierSegmentUploadInitiate(TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, Optional<UUID> previousObjectId, long baseOffset, long endOffset, long maxTimestamp, long firstBatchTimestamp, int size, boolean hasEpochState, boolean hasAbortedTxns, boolean hasProducerState, TierUploadType uploadType, io.confluent.kafka.storage.tier.state.OffsetAndEpoch stateOffset, OpaqueData opaqueData, Optional<List<FragmentDescriptionWrapper>> fragmentDescriptionsList) {
        this(topicIdPartition, tierEpoch, objectId, previousObjectId, baseOffset, endOffset, maxTimestamp, firstBatchTimestamp, size, hasEpochState, hasAbortedTxns, hasProducerState, uploadType, stateOffset, opaqueData, Optional.empty(), fragmentDescriptionsList);
    }

    public TierSegmentUploadInitiate(TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, Optional<UUID> previousObjectId, long baseOffset, long endOffset, long maxTimestamp, long firstBatchTimestamp, int size, boolean hasEpochState, boolean hasAbortedTxns, boolean hasProducerState, TierUploadType uploadType, io.confluent.kafka.storage.tier.state.OffsetAndEpoch stateOffset, OpaqueData opaqueData, Optional<ByteBuffer> encryptedDek, Optional<List<FragmentDescriptionWrapper>> fragmentDescriptionsList) {
        FlatBufferBuilder builder = new FlatBufferBuilder(TierSegmentUploadInitiate.initialBufferSize()).forceDefaults(false);
        int entryId = TierSegmentUploadInitiate.buildSegmentUploadInitiate(builder, tierEpoch, objectId, previousObjectId, baseOffset, endOffset, maxTimestamp, firstBatchTimestamp, size, hasEpochState, hasAbortedTxns, hasProducerState, uploadType, stateOffset, opaqueData, encryptedDek, fragmentDescriptionsList);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = SegmentUploadInitiate.getRootAsSegmentUploadInitiate(builder.dataBuffer());
    }

    static int buildSegmentUploadInitiate(FlatBufferBuilder builder, int tierEpoch, UUID objectId, Optional<UUID> previousObjectId, long baseOffset, long endOffset, long maxTimestamp, long firstBatchTimestamp, int size, boolean hasEpochState, boolean hasAbortedTxns, boolean hasProducerState, TierUploadType uploadType, io.confluent.kafka.storage.tier.state.OffsetAndEpoch stateOffset, OpaqueData opaqueData, Optional<ByteBuffer> encryptedDekOpt, Optional<List<FragmentDescriptionWrapper>> fragmentDescriptionsList) {
        Optional<Integer> segmentAndMetadataLayoutOffsetOpt = fragmentDescriptionsList.map(fragmentsList -> FragmentDescriptionWrapper.serializeFragmentDescriptionsIntoSegmentUploadInitiate(builder, fragmentsList));
        Optional<Integer> encryptedDekOffsetOpt = encryptedDekOpt.map(encryptedDek -> {
            if (encryptedDek.hasRemaining()) {
                return SegmentUploadInitiate.createEncryptedDekVector(builder, encryptedDek.duplicate());
            }
            return null;
        });
        SegmentUploadInitiate.startSegmentUploadInitiate(builder);
        SegmentUploadInitiate.addVersion(builder, (byte)4);
        SegmentUploadInitiate.addTierEpoch(builder, tierEpoch);
        int objectIdOffset = io.confluent.kafka.storage.tier.serdes.UUID.createUUID(builder, objectId.getMostSignificantBits(), objectId.getLeastSignificantBits());
        SegmentUploadInitiate.addObjectId(builder, objectIdOffset);
        previousObjectId.ifPresent(uuid -> {
            int previousObjectIdOffset = io.confluent.kafka.storage.tier.serdes.UUID.createUUID(builder, uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
            SegmentUploadInitiate.addPreviousObjectId(builder, previousObjectIdOffset);
        });
        SegmentUploadInitiate.addBaseOffset(builder, baseOffset);
        SegmentUploadInitiate.addEndOffsetDelta(builder, (int)(endOffset - baseOffset));
        SegmentUploadInitiate.addMaxTimestamp(builder, maxTimestamp);
        SegmentUploadInitiate.addSize(builder, size);
        SegmentUploadInitiate.addHasEpochState(builder, hasEpochState);
        SegmentUploadInitiate.addHasAbortedTxns(builder, hasAbortedTxns);
        SegmentUploadInitiate.addHasProducerState(builder, hasProducerState);
        SegmentUploadInitiate.addUploadType(builder, TierUploadType.toByte(uploadType));
        int offsetAndEpochId = OffsetAndEpoch.createOffsetAndEpoch(builder, stateOffset.offset(), stateOffset.epoch().orElse(-1));
        SegmentUploadInitiate.addStateOffsetAndEpoch(builder, offsetAndEpochId);
        if (!opaqueData.equals(OpaqueData.ZEROED)) {
            long[] arr = opaqueData.intoLongArray();
            int opaqueDataOffset = OpaqueDataField.createOpaqueDataField(builder, arr[0], arr[1], arr[2], arr[3]);
            SegmentUploadInitiate.addOpaqueData(builder, opaqueDataOffset);
        }
        SegmentUploadInitiate.addFirstBatchTimestamp(builder, firstBatchTimestamp);
        segmentAndMetadataLayoutOffsetOpt.ifPresent(segmentAndMetadataLayoutOffset -> SegmentUploadInitiate.addSegmentAndMetadataLayout(builder, segmentAndMetadataLayoutOffset));
        encryptedDekOffsetOpt.ifPresent(encryptedDekOffset -> SegmentUploadInitiate.addEncryptedDek(builder, encryptedDekOffset));
        return SegmentUploadInitiate.endSegmentUploadInitiate(builder);
    }

    public TierSegmentUploadInitiate(TopicIdPartition topicIdPartition, SegmentUploadInitiate metadata) {
        if (metadata.version() >= 1 && metadata.stateOffsetAndEpoch() == null) {
            throw new IllegalArgumentException(String.format("TierSegmentUploadInitiate version %d must contain a stateOffsetAndEpoch.", metadata.version()));
        }
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    public static int initialBufferSize() {
        return 160;
    }

    @Override
    public TierObjectMetadata.State state() {
        return TierObjectMetadata.State.SEGMENT_UPLOAD_INITIATE;
    }

    public long baseOffset() {
        return this.metadata.baseOffset();
    }

    public long endOffset() {
        return this.metadata.baseOffset() + (long)this.metadata.endOffsetDelta();
    }

    public long maxTimestamp() {
        return this.metadata.maxTimestamp();
    }

    public int size() {
        return this.metadata.size();
    }

    public boolean hasEpochState() {
        return this.metadata.hasEpochState();
    }

    public boolean hasAbortedTxns() {
        return this.metadata.hasAbortedTxns();
    }

    public boolean hasProducerState() {
        return this.metadata.hasProducerState();
    }

    public TierUploadType uploadType() {
        return TierUploadType.fromByte(this.metadata.uploadType());
    }

    public long firstBatchTimestamp() {
        return this.metadata.firstBatchTimestamp();
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.SegmentUploadInitiate;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public int tierEpoch() {
        return this.metadata.tierEpoch();
    }

    @Override
    public io.confluent.kafka.storage.tier.state.OffsetAndEpoch stateOffsetAndEpoch() {
        return this.metadata.stateOffsetAndEpoch() == null ? io.confluent.kafka.storage.tier.state.OffsetAndEpoch.EMPTY : new io.confluent.kafka.storage.tier.state.OffsetAndEpoch(this.metadata.stateOffsetAndEpoch());
    }

    public OpaqueData opaqueData() {
        OpaqueDataField opaque = this.metadata.opaqueData();
        if (opaque == null) {
            return OpaqueData.ZEROED;
        }
        long[] arr = new long[]{opaque.f0(), opaque.f1(), opaque.f2(), opaque.f3()};
        return OpaqueData.fromLongArray(arr);
    }

    public Optional<ByteBuffer> encryptedDek() {
        return Optional.ofNullable(this.metadata.encryptedDekVector()).map(encryptedDekVec -> {
            byte[] encryptedDekBuffer = new byte[this.metadata.encryptedDekLength()];
            for (int index = 0; index < encryptedDekBuffer.length; ++index) {
                encryptedDekBuffer[index] = this.metadata.encryptedDek(index);
            }
            return ByteBuffer.wrap(encryptedDekBuffer);
        });
    }

    public Optional<UUID> previousObjectId() {
        return Optional.ofNullable(this.metadata.previousObjectId()).map(id -> new UUID(id.mostSignificantBits(), id.leastSignificantBits()));
    }

    public Optional<SegmentAndMetadataLayout> segmentAndMetadataLayout() {
        try {
            return Optional.ofNullable(this.metadata.segmentAndMetadataLayoutVector()).map(fragmentDescriptionVec -> new SegmentAndMetadataLayout((FragmentDescription.Vector)((Object)fragmentDescriptionVec), this.metadata.segmentAndMetadataLayoutLength()));
        }
        catch (Exception e) {
            throw new TierMetadataDeserializationException("Caught exception while attempting to deserialize SegmentAndMetadataLayout vector from uploadInitiate event.", e);
        }
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public UUID messageId() {
        io.confluent.kafka.storage.tier.serdes.UUID objectId = this.metadata.objectId();
        return new UUID(objectId.mostSignificantBits(), objectId.leastSignificantBits());
    }

    public String toString() {
        return "TierSegmentUploadInitiate(version=" + this.metadata.version() + ", topicIdPartition=" + String.valueOf(this.topicIdPartition()) + ", tierEpoch=" + this.tierEpoch() + ", objectIdAsBase64=" + this.objectIdAsBase64() + ", baseOffset=" + this.baseOffset() + ", endOffset=" + this.endOffset() + ", maxTimestamp=" + this.maxTimestamp() + ", size=" + this.size() + ", hasEpochState=" + this.hasEpochState() + ", hasAbortedTxns=" + this.hasAbortedTxns() + ", hasProducerState=" + this.hasProducerState() + ", uploadType=" + String.valueOf((Object)this.uploadType()) + ", stateOffsetAndEpoch=" + String.valueOf(this.stateOffsetAndEpoch()) + ", opaqueData=" + String.valueOf(this.opaqueData()) + ", firstRecordBatchTimestamp=" + this.firstBatchTimestamp() + ", segmentAndMetadataLayout=" + String.valueOf(this.segmentAndMetadataLayout()) + ", )";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TierSegmentUploadInitiate that = (TierSegmentUploadInitiate)o;
        return Objects.equals(this.topicIdPartition(), that.topicIdPartition()) && Objects.equals(this.metadata.version(), that.metadata.version()) && Objects.equals(this.tierEpoch(), that.tierEpoch()) && Objects.equals(this.objectId(), that.objectId()) && Objects.equals(this.baseOffset(), that.baseOffset()) && Objects.equals(this.endOffset(), that.endOffset()) && Objects.equals(this.maxTimestamp(), that.maxTimestamp()) && Objects.equals(this.size(), that.size()) && Objects.equals(this.hasEpochState(), that.hasEpochState()) && Objects.equals(this.hasAbortedTxns(), that.hasAbortedTxns()) && Objects.equals(this.hasProducerState(), that.hasProducerState()) && Objects.equals((Object)this.uploadType(), (Object)that.uploadType()) && Objects.equals(this.stateOffsetAndEpoch(), that.stateOffsetAndEpoch()) && Objects.equals(this.opaqueData(), that.opaqueData()) && Objects.equals(this.encryptedDek(), that.encryptedDek()) && Objects.equals(this.firstBatchTimestamp(), that.firstBatchTimestamp()) && Objects.equals(this.segmentAndMetadataLayout(), that.segmentAndMetadataLayout());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.metadata.version(), this.tierEpoch(), this.objectId(), this.baseOffset(), this.endOffset(), this.maxTimestamp(), this.size(), this.hasEpochState(), this.hasAbortedTxns(), this.hasProducerState(), this.uploadType(), this.stateOffsetAndEpoch(), this.opaqueData(), this.encryptedDek(), this.firstBatchTimestamp(), this.segmentAndMetadataLayout()});
    }
}

