/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public final class FollowerRestorePoint {
    public final long localLogStartOffset;
    public final Optional<UUID> targetObjectId;
    public final int targetRestoreEpoch;

    public FollowerRestorePoint(long localLogStartOffset, Optional<UUID> targetObjectId, int targetRestoreEpoch) {
        Objects.requireNonNull(targetObjectId, "targetObjectId should not be null");
        this.localLogStartOffset = localLogStartOffset;
        this.targetObjectId = targetObjectId;
        this.targetRestoreEpoch = targetRestoreEpoch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FollowerRestorePoint that = (FollowerRestorePoint)o;
        return this.localLogStartOffset == that.localLogStartOffset && this.targetRestoreEpoch == that.targetRestoreEpoch && this.targetObjectId.equals(that.targetObjectId);
    }

    public int hashCode() {
        return Objects.hash(this.localLogStartOffset, this.targetObjectId, this.targetRestoreEpoch);
    }

    public String toString() {
        return "FollowerRestorePoint(localLogStartOffset=" + this.localLogStartOffset + ", targetObjectId=" + String.valueOf(this.targetObjectId) + ", targetRestoreEpoch=" + this.targetRestoreEpoch + ")";
    }
}

