/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueLoggedStore;

public class MemoryLRUCache<K, V>
implements KeyValueStore<K, V> {
    protected String name;
    protected Map<K, V> map;
    protected Set<K> keys;
    protected EldestEntryRemovalListener<K, V> listener;

    public MemoryLRUCache() {
    }

    public MemoryLRUCache(String name, final int maxCacheSize) {
        this.name = name;
        this.keys = new HashSet<K>();
        this.map = new LinkedHashMap<K, V>(maxCacheSize + 1, 1.01f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                if (this.size() > maxCacheSize) {
                    Object key = eldest.getKey();
                    MemoryLRUCache.this.keys.remove(key);
                    if (MemoryLRUCache.this.listener != null) {
                        MemoryLRUCache.this.listener.apply(key, eldest.getValue());
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public KeyValueStore<K, V> enableLogging(Serde<K> keySerde, Serde<V> valueSerde) {
        return new InMemoryKeyValueLoggedStore<K, V>(this.name, this, keySerde, valueSerde);
    }

    public MemoryLRUCache<K, V> whenEldestRemoved(EldestEntryRemovalListener<K, V> listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
    }

    @Override
    public boolean persistent() {
        return false;
    }

    @Override
    public V get(K key) {
        return this.map.get(key);
    }

    @Override
    public void put(K key, V value) {
        this.map.put(key, value);
        this.keys.add(key);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V originalValue = this.get(key);
        if (originalValue == null) {
            this.put(key, value);
        }
        return originalValue;
    }

    @Override
    public void putAll(List<KeyValue<K, V>> entries) {
        for (KeyValue<K, V> entry : entries) {
            this.put(entry.key, entry.value);
        }
    }

    @Override
    public V delete(K key) {
        V value = this.map.remove(key);
        this.keys.remove(key);
        return value;
    }

    @Override
    public KeyValueIterator<K, V> range(K from, K to) {
        throw new UnsupportedOperationException("MemoryLRUCache does not support range() function.");
    }

    @Override
    public KeyValueIterator<K, V> all() {
        throw new UnsupportedOperationException("MemoryLRUCache does not support all() function.");
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public static interface EldestEntryRemovalListener<K, V> {
        public void apply(K var1, V var2);
    }
}

