/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableKTableAbstractJoin;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;

class KTableKTableJoin<K, R, V1, V2>
extends KTableKTableAbstractJoin<K, R, V1, V2> {
    KTableKTableJoin(KTableImpl<K, ?, V1> table1, KTableImpl<K, ?, V2> table2, ValueJoiner<V1, V2, R> joiner) {
        super(table1, table2, joiner);
    }

    @Override
    public Processor<K, Change<V1>> get() {
        return new KTableKTableJoinProcessor(this.valueGetterSupplier2.get());
    }

    @Override
    public KTableValueGetterSupplier<K, R> view() {
        return new KTableValueGetterSupplier<K, R>(){

            @Override
            public KTableValueGetter<K, R> get() {
                return new KTableKTableJoinValueGetter(KTableKTableJoin.this.valueGetterSupplier1.get(), KTableKTableJoin.this.valueGetterSupplier2.get());
            }
        };
    }

    private class KTableKTableJoinValueGetter
    implements KTableValueGetter<K, R> {
        private final KTableValueGetter<K, V1> valueGetter1;
        private final KTableValueGetter<K, V2> valueGetter2;

        public KTableKTableJoinValueGetter(KTableValueGetter<K, V1> valueGetter1, KTableValueGetter<K, V2> valueGetter2) {
            this.valueGetter1 = valueGetter1;
            this.valueGetter2 = valueGetter2;
        }

        @Override
        public void init(ProcessorContext context) {
            this.valueGetter1.init(context);
            this.valueGetter2.init(context);
        }

        @Override
        public R get(K key) {
            Object value2;
            Object newValue = null;
            Object value1 = this.valueGetter1.get(key);
            if (value1 != null && (value2 = this.valueGetter2.get(key)) != null) {
                newValue = KTableKTableJoin.this.joiner.apply(value1, value2);
            }
            return newValue;
        }
    }

    private class KTableKTableJoinProcessor
    extends AbstractProcessor<K, Change<V1>> {
        private final KTableValueGetter<K, V2> valueGetter;

        public KTableKTableJoinProcessor(KTableValueGetter<K, V2> valueGetter) {
            this.valueGetter = valueGetter;
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.valueGetter.init(context);
        }

        @Override
        public void process(K key, Change<V1> change) {
            if (key == null) {
                throw new StreamsException("Record key for KTable join operator should not be null.");
            }
            Object newValue = null;
            Object oldValue = null;
            Object value2 = null;
            if (change.newValue != null || change.oldValue != null) {
                value2 = this.valueGetter.get(key);
            }
            if (change.newValue != null && value2 != null) {
                newValue = KTableKTableJoin.this.joiner.apply(change.newValue, value2);
            }
            if (KTableKTableJoin.this.sendOldValues && change.oldValue != null && value2 != null) {
                oldValue = KTableKTableJoin.this.joiner.apply(change.oldValue, value2);
            }
            this.context().forward(key, new Change<Object>(newValue, oldValue));
        }
    }
}

