/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.ChangedSerializer;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.RecordCollector;

public class SinkNode<K, V>
extends ProcessorNode<K, V> {
    private final String topic;
    private Serializer<K> keySerializer;
    private Serializer<V> valSerializer;
    private final StreamPartitioner<K, V> partitioner;
    private ProcessorContext context;

    public SinkNode(String name, String topic, Serializer<K> keySerializer, Serializer<V> valSerializer, StreamPartitioner<K, V> partitioner) {
        super(name);
        this.topic = topic;
        this.keySerializer = keySerializer;
        this.valSerializer = valSerializer;
        this.partitioner = partitioner;
    }

    @Override
    public void addChild(ProcessorNode<?, ?> child) {
        throw new UnsupportedOperationException("sink node does not allow addChild");
    }

    @Override
    public void init(ProcessorContext context) {
        this.context = context;
        if (this.keySerializer == null) {
            this.keySerializer = context.keySerde().serializer();
        }
        if (this.valSerializer == null) {
            this.valSerializer = context.valueSerde().serializer();
        }
        if (this.valSerializer instanceof ChangedSerializer && ((ChangedSerializer)this.valSerializer).inner() == null) {
            ((ChangedSerializer)this.valSerializer).setInner(context.valueSerde().serializer());
        }
    }

    @Override
    public void process(K key, V value) {
        RecordCollector collector = ((RecordCollector.Supplier)((Object)this.context)).recordCollector();
        collector.send(new ProducerRecord(this.topic, null, Long.valueOf(this.context.timestamp()), key, value), this.keySerializer, this.valSerializer, this.partitioner);
    }

    @Override
    public void close() {
    }

    public Serializer<V> valueSerializer() {
        return this.valSerializer;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("topic:" + this.topic);
        return sb.toString();
    }
}

