/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.MemoryLRUCache;

public class MemoryNavigableLRUCache<K, V>
extends MemoryLRUCache<K, V> {
    public MemoryNavigableLRUCache(String name, int maxCacheSize, Serde<K> keySerde, Serde<V> valueSerde) {
        super(name, maxCacheSize, keySerde, valueSerde);
    }

    @Override
    public MemoryNavigableLRUCache<K, V> whenEldestRemoved(MemoryLRUCache.EldestEntryRemovalListener<K, V> listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public KeyValueIterator<K, V> range(K from, K to) {
        TreeMap<K, V> treeMap = this.toTreeMap();
        return new CacheIterator<K, V>(treeMap.navigableKeySet().subSet(from, true, to, true).iterator(), treeMap);
    }

    @Override
    public KeyValueIterator<K, V> all() {
        TreeMap<K, V> treeMap = this.toTreeMap();
        return new CacheIterator<K, V>(treeMap.navigableKeySet().iterator(), treeMap);
    }

    private synchronized TreeMap<K, V> toTreeMap() {
        return new TreeMap(this.map);
    }

    private static class CacheIterator<K, V>
    implements KeyValueIterator<K, V> {
        private final Iterator<K> keys;
        private final Map<K, V> entries;
        private K lastKey;

        public CacheIterator(Iterator<K> keys, Map<K, V> entries) {
            this.keys = keys;
            this.entries = entries;
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        @Override
        public KeyValue<K, V> next() {
            this.lastKey = this.keys.next();
            return new KeyValue<K, V>(this.lastKey, this.entries.get(this.lastKey));
        }

        @Override
        public void remove() {
        }

        @Override
        public void close() {
        }
    }
}

