/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Map;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.internals.AbstractStoreSupplier;
import org.apache.kafka.streams.state.internals.CachingKeyValueStore;
import org.apache.kafka.streams.state.internals.MeteredKeyValueStore;
import org.apache.kafka.streams.state.internals.RocksDBStore;

public class RocksDBKeyValueStoreSupplier<K, V>
extends AbstractStoreSupplier<K, V> {
    private final boolean enableCaching;

    public RocksDBKeyValueStoreSupplier(String name, Serde<K> keySerde, Serde<V> valueSerde, boolean logged, Map<String, String> logConfig, boolean enableCaching) {
        this(name, keySerde, valueSerde, null, logged, logConfig, enableCaching);
    }

    public RocksDBKeyValueStoreSupplier(String name, Serde<K> keySerde, Serde<V> valueSerde, Time time, boolean logged, Map<String, String> logConfig, boolean enableCaching) {
        super(name, keySerde, valueSerde, time, logged, logConfig);
        this.enableCaching = enableCaching;
    }

    @Override
    public StateStore get() {
        if (!this.enableCaching) {
            RocksDBStore store = new RocksDBStore(this.name, this.keySerde, this.valueSerde);
            return new MeteredKeyValueStore(this.logged ? store.enableLogging() : store, "rocksdb-state", this.time);
        }
        RocksDBStore store = new RocksDBStore(this.name, Serdes.Bytes(), Serdes.ByteArray());
        return new CachingKeyValueStore(new MeteredKeyValueStore<Bytes, byte[]>(this.logged ? store.enableLogging() : store, "rocksdb-state", this.time), this.keySerde, this.valueSerde);
    }
}

