/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.StoreChangeLogger;
import org.apache.kafka.streams.state.internals.WindowStoreUtils;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public class ChangeLoggingKeyValueBytesStore
extends WrappedStateStore.AbstractWrappedStateStore
implements KeyValueStore<Bytes, byte[]> {
    private final KeyValueStore<Bytes, byte[]> inner;
    private StoreChangeLogger<Bytes, byte[]> changeLogger;

    public ChangeLoggingKeyValueBytesStore(KeyValueStore<Bytes, byte[]> inner) {
        super(inner);
        this.inner = inner;
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.inner.init(context, root);
        this.changeLogger = new StoreChangeLogger<Bytes, byte[]>(this.inner.name(), context, WindowStoreUtils.INNER_SERDES);
    }

    @Override
    public void put(Bytes key, byte[] value) {
        this.inner.put(key, value);
        this.changeLogger.logChange(key, value);
    }

    @Override
    public byte[] putIfAbsent(Bytes key, byte[] value) {
        byte[] previous = this.get(key);
        if (previous == null) {
            this.put(key, value);
        }
        return previous;
    }

    @Override
    public void putAll(List<KeyValue<Bytes, byte[]>> entries) {
        this.inner.putAll(entries);
        for (KeyValue entry : entries) {
            this.changeLogger.logChange((Bytes)entry.key, (byte[])entry.value);
        }
    }

    @Override
    public byte[] delete(Bytes key) {
        byte[] oldValue = (byte[])this.inner.get(key);
        this.put(key, null);
        return oldValue;
    }

    @Override
    public byte[] get(Bytes key) {
        return (byte[])this.inner.get(key);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> range(Bytes from, Bytes to) {
        return this.inner.range(from, to);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> all() {
        return this.inner.all();
    }

    @Override
    public long approximateNumEntries() {
        return this.inner.approximateNumEntries();
    }
}

