/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.streams.processor.internals.RecordContext;

class LRUCacheEntry
implements RecordContext {
    public final byte[] value;
    private final long offset;
    private final long timestamp;
    private final String topic;
    boolean isDirty;
    private final int partition;
    private long sizeBytes = 0L;

    LRUCacheEntry(byte[] value) {
        this(value, false, -1L, -1L, -1, "");
    }

    LRUCacheEntry(byte[] value, boolean isDirty, long offset, long timestamp, int partition, String topic) {
        this.value = value;
        this.partition = partition;
        this.topic = topic;
        this.offset = offset;
        this.isDirty = isDirty;
        this.timestamp = timestamp;
        this.sizeBytes = (value == null ? 0 : value.length) + 1 + 8 + 8 + 4 + (topic == null ? 0 : topic.length());
    }

    void markClean() {
        this.isDirty = false;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public String topic() {
        return this.topic;
    }

    @Override
    public int partition() {
        return this.partition;
    }

    boolean isDirty() {
        return this.isDirty;
    }

    public long size() {
        return this.sizeBytes;
    }
}

