/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.DefaultPartitionGrouper;
import org.apache.kafka.streams.processor.FailOnInvalidTimestamp;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.internals.StreamPartitionAssignor;
import org.apache.kafka.streams.processor.internals.StreamThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamsConfig
extends AbstractConfig {
    private static final Logger log = LoggerFactory.getLogger(StreamsConfig.class);
    private static final ConfigDef CONFIG = new ConfigDef().define("application.id", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "An identifier for the stream processing application. Must be unique within the Kafka cluster. It is used as 1) the default client-id prefix, 2) the group-id for membership management, 3) the changelog topic prefix.").define("bootstrap.servers", ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).").define("replication.factor", ConfigDef.Type.INT, (Object)1, ConfigDef.Importance.HIGH, "The replication factor for change log topics and repartition topics created by the stream processing application.").define("state.dir", ConfigDef.Type.STRING, (Object)"/tmp/kafka-streams", ConfigDef.Importance.HIGH, "Directory location for state store.").define("cache.max.bytes.buffering", ConfigDef.Type.LONG, (Object)0xA00000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "Maximum number of memory bytes to be used for buffering across all threads").define("client.id", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "An id string to pass to the server when making requests. The purpose of this is to be able to track the source of requests beyond just ip/port by allowing a logical application name to be included in server-side request logging.").define("default.key.serde", ConfigDef.Type.CLASS, (Object)Serdes.ByteArraySerde.class.getName(), ConfigDef.Importance.MEDIUM, " Default serializer / deserializer class for key that implements the <code>Serde</code> interface.").define("default.timestamp.extractor", ConfigDef.Type.CLASS, (Object)FailOnInvalidTimestamp.class.getName(), ConfigDef.Importance.MEDIUM, "Default timestamp extractor class that implements the <code>TimestampExtractor</code> interface.").define("default.value.serde", ConfigDef.Type.CLASS, (Object)Serdes.ByteArraySerde.class.getName(), ConfigDef.Importance.MEDIUM, "Default serializer / deserializer class for value that implements the <code>Serde</code> interface.").define("num.standby.replicas", ConfigDef.Type.INT, (Object)0, ConfigDef.Importance.MEDIUM, "The number of standby replicas for each task.").define("num.stream.threads", ConfigDef.Type.INT, (Object)1, ConfigDef.Importance.MEDIUM, "The number of threads to execute stream processing.").define("processing.guarantee", ConfigDef.Type.STRING, (Object)"at_least_once", (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{"at_least_once", "exactly_once"}), ConfigDef.Importance.MEDIUM, "The processing guarantee that should be used. Possible values are <code>at_least_once</code> (default) and <code>exactly_once</code>.").define("security.protocol", ConfigDef.Type.STRING, (Object)"PLAINTEXT", ConfigDef.Importance.MEDIUM, CommonClientConfigs.SECURITY_PROTOCOL_DOC).define("application.server", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "A host:port pair pointing to an embedded user defined endpoint that can be used for discovering the locations of state stores within a single KafkaStreams application").define("buffered.records.per.partition", ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.LOW, "The maximum number of records to buffer per partition.").define("commit.interval.ms", ConfigDef.Type.LONG, (Object)30000L, ConfigDef.Importance.LOW, "The frequency with which to save the position of the processor. (Note, if 'processing.guarantee' is set to 'exactly_once', the default value is 100, otherwise the default value is 30000.").define("connections.max.idle.ms", ConfigDef.Type.LONG, (Object)540000, ConfigDef.Importance.LOW, "Close idle connections after the number of milliseconds specified by this config.").define("metadata.max.age.ms", ConfigDef.Type.LONG, (Object)300000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, "The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.").define("metrics.num.samples", ConfigDef.Type.INT, (Object)2, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "The number of samples maintained to compute metrics.").define("metric.reporters", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "A list of classes to use as metrics reporters. Implementing the <code>MetricReporter</code> interface allows plugging in classes that will be notified of new metric creation. The JmxReporter is always included to register JMX statistics.").define("metrics.recording.level", ConfigDef.Type.STRING, (Object)Sensor.RecordingLevel.INFO.toString(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{Sensor.RecordingLevel.INFO.toString(), Sensor.RecordingLevel.DEBUG.toString()}), ConfigDef.Importance.LOW, "The highest recording level for metrics.").define("metrics.sample.window.ms", ConfigDef.Type.LONG, (Object)30000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, "The window of time a metrics sample is computed over.").define("partition.grouper", ConfigDef.Type.CLASS, (Object)DefaultPartitionGrouper.class.getName(), ConfigDef.Importance.LOW, "Partition grouper class that implements the <code>PartitionGrouper</code> interface.").define("poll.ms", ConfigDef.Type.LONG, (Object)100, ConfigDef.Importance.LOW, "The amount of time in milliseconds to block waiting for input.").define("receive.buffer.bytes", ConfigDef.Type.INT, (Object)32768, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, "The size of the TCP receive buffer (SO_RCVBUF) to use when reading data. If the value is -1, the OS default will be used.").define("reconnect.backoff.ms", ConfigDef.Type.LONG, (Object)50L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.LOW, "The base amount of time to wait before attempting to reconnect to a given host. This avoids repeatedly connecting to a host in a tight loop. This backoff applies to all connection attempts by the client to a broker.").define("reconnect.backoff.max.ms", ConfigDef.Type.LONG, (Object)1000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.LOW, "The maximum amount of time in milliseconds to wait when reconnectng to a broker that has repeatedly failed to connect. If provided, the backoff per host will increase exponentially for each consecutive connection failure, up to this maximum. After calculating the backoff increase, 20% random jitter is added to avoid connection storms.").define("retry.backoff.ms", ConfigDef.Type.LONG, (Object)100L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.LOW, "The amount of time to wait before attempting to retry a failed request to a given topic partition. This avoids repeatedly sending requests in a tight loop under some failure scenarios.").define("request.timeout.ms", ConfigDef.Type.INT, (Object)40000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, "The configuration controls the maximum amount of time the client will wait for the response of a request. If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.").define("rocksdb.config.setter", ConfigDef.Type.CLASS, null, ConfigDef.Importance.LOW, "A Rocks DB config setter class or class name that implements the <code>RocksDBConfigSetter</code> interface").define("send.buffer.bytes", ConfigDef.Type.INT, (Object)131072, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, "The size of the TCP send buffer (SO_SNDBUF) to use when sending data. If the value is -1, the OS default will be used.").define("state.cleanup.delay.ms", ConfigDef.Type.LONG, (Object)600000, ConfigDef.Importance.LOW, "The amount of time in milliseconds to wait before deleting state when a partition has migrated. Only state directories that have not been modified for at least state.cleanup.delay.ms will be removed").define("windowstore.changelog.additional.retention.ms", ConfigDef.Type.LONG, (Object)86400000, ConfigDef.Importance.LOW, "Added to a windows maintainMs to ensure data is not deleted from the log prematurely. Allows for clock drift. Default is 1 day").define("key.serde", ConfigDef.Type.CLASS, null, ConfigDef.Importance.LOW, "Serializer / deserializer class for key that implements the <code>Serde</code> interface. This config is deprecated, use <code>default.key.serde</code> instead").define("timestamp.extractor", ConfigDef.Type.CLASS, null, ConfigDef.Importance.LOW, "Timestamp extractor class that implements the <code>TimestampExtractor</code> interface. This config is deprecated, use <code>default.timestamp.extractor</code> instead").define("value.serde", ConfigDef.Type.CLASS, null, ConfigDef.Importance.LOW, "Serializer / deserializer class for value that implements the <code>Serde</code> interface. This config is deprecated, use <code>default.value.serde</code> instead").define("zookeeper.connect", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "Zookeeper connect string for Kafka topics management. This config is deprecated and will be ignored as Streams API does not use Zookeeper anymore.");
    private final boolean eosEnabled = "exactly_once".equals(this.getString("processing.guarantee"));
    private static final long DEFAULT_COMMIT_INTERVAL_MS = 30000L;
    private static final long EOS_DEFAULT_COMMIT_INTERVAL_MS = 100L;
    public static final String CONSUMER_PREFIX = "consumer.";
    public static final String PRODUCER_PREFIX = "producer.";
    public static final String AT_LEAST_ONCE = "at_least_once";
    public static final String EXACTLY_ONCE = "exactly_once";
    public static final String APPLICATION_ID_CONFIG = "application.id";
    private static final String APPLICATION_ID_DOC = "An identifier for the stream processing application. Must be unique within the Kafka cluster. It is used as 1) the default client-id prefix, 2) the group-id for membership management, 3) the changelog topic prefix.";
    public static final String APPLICATION_SERVER_CONFIG = "application.server";
    private static final String APPLICATION_SERVER_DOC = "A host:port pair pointing to an embedded user defined endpoint that can be used for discovering the locations of state stores within a single KafkaStreams application";
    public static final String BOOTSTRAP_SERVERS_CONFIG = "bootstrap.servers";
    public static final String BUFFERED_RECORDS_PER_PARTITION_CONFIG = "buffered.records.per.partition";
    private static final String BUFFERED_RECORDS_PER_PARTITION_DOC = "The maximum number of records to buffer per partition.";
    public static final String CACHE_MAX_BYTES_BUFFERING_CONFIG = "cache.max.bytes.buffering";
    private static final String CACHE_MAX_BYTES_BUFFERING_DOC = "Maximum number of memory bytes to be used for buffering across all threads";
    public static final String CLIENT_ID_CONFIG = "client.id";
    public static final String COMMIT_INTERVAL_MS_CONFIG = "commit.interval.ms";
    private static final String COMMIT_INTERVAL_MS_DOC = "The frequency with which to save the position of the processor. (Note, if 'processing.guarantee' is set to 'exactly_once', the default value is 100, otherwise the default value is 30000.";
    public static final String CONNECTIONS_MAX_IDLE_MS_CONFIG = "connections.max.idle.ms";
    public static final String DEFAULT_KEY_SERDE_CLASS_CONFIG = "default.key.serde";
    private static final String DEFAULT_KEY_SERDE_CLASS_DOC = " Default serializer / deserializer class for key that implements the <code>Serde</code> interface.";
    public static final String DEFAULT_TIMESTAMP_EXTRACTOR_CLASS_CONFIG = "default.timestamp.extractor";
    private static final String DEFAULT_TIMESTAMP_EXTRACTOR_CLASS_DOC = "Default timestamp extractor class that implements the <code>TimestampExtractor</code> interface.";
    public static final String DEFAULT_VALUE_SERDE_CLASS_CONFIG = "default.value.serde";
    private static final String DEFAULT_VALUE_SERDE_CLASS_DOC = "Default serializer / deserializer class for value that implements the <code>Serde</code> interface.";
    @Deprecated
    public static final String KEY_SERDE_CLASS_CONFIG = "key.serde";
    private static final String KEY_SERDE_CLASS_DOC = "Serializer / deserializer class for key that implements the <code>Serde</code> interface. This config is deprecated, use <code>default.key.serde</code> instead";
    public static final String METADATA_MAX_AGE_CONFIG = "metadata.max.age.ms";
    public static final String METRICS_NUM_SAMPLES_CONFIG = "metrics.num.samples";
    public static final String METRICS_RECORDING_LEVEL_CONFIG = "metrics.recording.level";
    public static final String METRIC_REPORTER_CLASSES_CONFIG = "metric.reporters";
    public static final String METRICS_SAMPLE_WINDOW_MS_CONFIG = "metrics.sample.window.ms";
    public static final String NUM_STANDBY_REPLICAS_CONFIG = "num.standby.replicas";
    private static final String NUM_STANDBY_REPLICAS_DOC = "The number of standby replicas for each task.";
    public static final String NUM_STREAM_THREADS_CONFIG = "num.stream.threads";
    private static final String NUM_STREAM_THREADS_DOC = "The number of threads to execute stream processing.";
    public static final String PARTITION_GROUPER_CLASS_CONFIG = "partition.grouper";
    private static final String PARTITION_GROUPER_CLASS_DOC = "Partition grouper class that implements the <code>PartitionGrouper</code> interface.";
    public static final String POLL_MS_CONFIG = "poll.ms";
    private static final String POLL_MS_DOC = "The amount of time in milliseconds to block waiting for input.";
    public static final String PROCESSING_GUARANTEE_CONFIG = "processing.guarantee";
    private static final String PROCESSING_GUARANTEE_DOC = "The processing guarantee that should be used. Possible values are <code>at_least_once</code> (default) and <code>exactly_once</code>.";
    public static final String RECEIVE_BUFFER_CONFIG = "receive.buffer.bytes";
    public static final String RECONNECT_BACKOFF_MS_CONFIG = "reconnect.backoff.ms";
    public static final String RECONNECT_BACKOFF_MAX_MS_CONFIG = "reconnect.backoff.max.ms";
    public static final String REPLICATION_FACTOR_CONFIG = "replication.factor";
    private static final String REPLICATION_FACTOR_DOC = "The replication factor for change log topics and repartition topics created by the stream processing application.";
    public static final String REQUEST_TIMEOUT_MS_CONFIG = "request.timeout.ms";
    public static final String RETRY_BACKOFF_MS_CONFIG = "retry.backoff.ms";
    public static final String ROCKSDB_CONFIG_SETTER_CLASS_CONFIG = "rocksdb.config.setter";
    private static final String ROCKSDB_CONFIG_SETTER_CLASS_DOC = "A Rocks DB config setter class or class name that implements the <code>RocksDBConfigSetter</code> interface";
    public static final String SECURITY_PROTOCOL_CONFIG = "security.protocol";
    public static final String SEND_BUFFER_CONFIG = "send.buffer.bytes";
    public static final String STATE_CLEANUP_DELAY_MS_CONFIG = "state.cleanup.delay.ms";
    private static final String STATE_CLEANUP_DELAY_MS_DOC = "The amount of time in milliseconds to wait before deleting state when a partition has migrated. Only state directories that have not been modified for at least state.cleanup.delay.ms will be removed";
    public static final String STATE_DIR_CONFIG = "state.dir";
    private static final String STATE_DIR_DOC = "Directory location for state store.";
    @Deprecated
    public static final String TIMESTAMP_EXTRACTOR_CLASS_CONFIG = "timestamp.extractor";
    private static final String TIMESTAMP_EXTRACTOR_CLASS_DOC = "Timestamp extractor class that implements the <code>TimestampExtractor</code> interface. This config is deprecated, use <code>default.timestamp.extractor</code> instead";
    @Deprecated
    public static final String VALUE_SERDE_CLASS_CONFIG = "value.serde";
    private static final String VALUE_SERDE_CLASS_DOC = "Serializer / deserializer class for value that implements the <code>Serde</code> interface. This config is deprecated, use <code>default.value.serde</code> instead";
    public static final String WINDOW_STORE_CHANGE_LOG_ADDITIONAL_RETENTION_MS_CONFIG = "windowstore.changelog.additional.retention.ms";
    private static final String WINDOW_STORE_CHANGE_LOG_ADDITIONAL_RETENTION_MS_DOC = "Added to a windows maintainMs to ensure data is not deleted from the log prematurely. Allows for clock drift. Default is 1 day";
    @Deprecated
    public static final String ZOOKEEPER_CONNECT_CONFIG = "zookeeper.connect";
    private static final String ZOOKEEPER_CONNECT_DOC = "Zookeeper connect string for Kafka topics management. This config is deprecated and will be ignored as Streams API does not use Zookeeper anymore.";
    private static final Map<String, Object> PRODUCER_DEFAULT_OVERRIDES;
    private static final Map<String, Object> PRODUCER_EOS_OVERRIDES;
    private static final Map<String, Object> CONSUMER_DEFAULT_OVERRIDES;
    private static final Map<String, Object> CONSUMER_EOS_OVERRIDES;

    public static String consumerPrefix(String consumerProp) {
        return CONSUMER_PREFIX + consumerProp;
    }

    public static String producerPrefix(String producerProp) {
        return PRODUCER_PREFIX + producerProp;
    }

    public static ConfigDef configDef() {
        return new ConfigDef(CONFIG);
    }

    public StreamsConfig(Map<?, ?> props) {
        super(CONFIG, props);
    }

    protected Map<String, Object> postProcessParsedConfig(Map<String, Object> parsedValues) {
        Map configUpdates = CommonClientConfigs.postProcessReconnectBackoffConfigs((AbstractConfig)this, parsedValues);
        boolean eosEnabled = EXACTLY_ONCE.equals(parsedValues.get(PROCESSING_GUARANTEE_CONFIG));
        if (eosEnabled && !this.originals().containsKey(COMMIT_INTERVAL_MS_CONFIG)) {
            log.debug("Using commit.interval.ms default value of 100 as exactly once is enabled.");
            configUpdates.put(COMMIT_INTERVAL_MS_CONFIG, 100L);
        }
        return configUpdates;
    }

    private Map<String, Object> getCommonConsumerConfigs() throws ConfigException {
        Map<String, Object> clientProvidedProps = this.getClientPropsWithPrefix(CONSUMER_PREFIX, ConsumerConfig.configNames());
        if (clientProvidedProps.containsKey("enable.auto.commit")) {
            throw new ConfigException("Unexpected user-specified consumer config enable.auto.commit, as the streams client will always turn off auto committing.");
        }
        if (this.eosEnabled && clientProvidedProps.containsKey("isolation.level")) {
            throw new ConfigException("Unexpected user-specified consumer config isolation.level; because processing.guarantee is set to 'exactly_once' consumers will always read committed data only.");
        }
        HashMap<String, Object> consumerProps = new HashMap<String, Object>(this.eosEnabled ? CONSUMER_EOS_OVERRIDES : CONSUMER_DEFAULT_OVERRIDES);
        consumerProps.putAll(clientProvidedProps);
        consumerProps.put(BOOTSTRAP_SERVERS_CONFIG, this.originals().get(BOOTSTRAP_SERVERS_CONFIG));
        consumerProps.remove(ZOOKEEPER_CONNECT_CONFIG);
        return consumerProps;
    }

    public Map<String, Object> getConsumerConfigs(StreamThread streamThread, String groupId, String clientId) throws ConfigException {
        Map<String, Object> consumerProps = this.getCommonConsumerConfigs();
        consumerProps.put("group.id", groupId);
        consumerProps.put(CLIENT_ID_CONFIG, clientId + "-consumer");
        consumerProps.put("__stream.thread.instance__", streamThread);
        consumerProps.put(REPLICATION_FACTOR_CONFIG, this.getInt(REPLICATION_FACTOR_CONFIG));
        consumerProps.put(NUM_STANDBY_REPLICAS_CONFIG, this.getInt(NUM_STANDBY_REPLICAS_CONFIG));
        consumerProps.put("partition.assignment.strategy", StreamPartitionAssignor.class.getName());
        consumerProps.put(WINDOW_STORE_CHANGE_LOG_ADDITIONAL_RETENTION_MS_CONFIG, this.getLong(WINDOW_STORE_CHANGE_LOG_ADDITIONAL_RETENTION_MS_CONFIG));
        consumerProps.put(APPLICATION_SERVER_CONFIG, this.getString(APPLICATION_SERVER_CONFIG));
        return consumerProps;
    }

    public Map<String, Object> getRestoreConsumerConfigs(String clientId) throws ConfigException {
        Map<String, Object> consumerProps = this.getCommonConsumerConfigs();
        consumerProps.remove("group.id");
        consumerProps.put(CLIENT_ID_CONFIG, clientId + "-restore-consumer");
        return consumerProps;
    }

    public Map<String, Object> getProducerConfigs(String clientId) {
        Map<String, Object> clientProvidedProps = this.getClientPropsWithPrefix(PRODUCER_PREFIX, ProducerConfig.configNames());
        if (this.eosEnabled) {
            if (clientProvidedProps.containsKey("enable.idempotence")) {
                throw new ConfigException("Unexpected user-specified consumer config enable.idempotence; because processing.guarantee is set to 'exactly_once' producer will always have idempotency enabled.");
            }
            if (clientProvidedProps.containsKey("max.in.flight.requests.per.connection")) {
                throw new ConfigException("Unexpected user-specified consumer config max.in.flight.requests.per.connection; because processing.guarantee is set to 'exactly_once' producer will always have only one in-flight request per connection.");
            }
        }
        HashMap<String, Object> props = new HashMap<String, Object>(this.eosEnabled ? PRODUCER_EOS_OVERRIDES : PRODUCER_DEFAULT_OVERRIDES);
        props.putAll(clientProvidedProps);
        props.put(BOOTSTRAP_SERVERS_CONFIG, this.originals().get(BOOTSTRAP_SERVERS_CONFIG));
        props.put(CLIENT_ID_CONFIG, clientId + "-producer");
        return props;
    }

    private Map<String, Object> getClientPropsWithPrefix(String prefix, Set<String> configNames) {
        Map<String, Object> props = this.clientProps(configNames, this.originals());
        props.putAll(this.originalsWithPrefix(prefix));
        return props;
    }

    @Deprecated
    public Serde keySerde() {
        return this.defaultKeySerde();
    }

    public Serde defaultKeySerde() {
        Object keySerdeConfigSetting = this.get(KEY_SERDE_CLASS_CONFIG);
        try {
            Serde serde = (Serde)this.getConfiguredInstance(KEY_SERDE_CLASS_CONFIG, Serde.class);
            if (serde == null) {
                keySerdeConfigSetting = this.get(DEFAULT_KEY_SERDE_CLASS_CONFIG);
                serde = (Serde)this.getConfiguredInstance(DEFAULT_KEY_SERDE_CLASS_CONFIG, Serde.class);
            }
            serde.configure(this.originals(), true);
            return serde;
        }
        catch (Exception e) {
            throw new StreamsException(String.format("Failed to configure key serde %s", keySerdeConfigSetting), e);
        }
    }

    @Deprecated
    public Serde valueSerde() {
        return this.defaultValueSerde();
    }

    public Serde defaultValueSerde() {
        Object valueSerdeConfigSetting = this.get(VALUE_SERDE_CLASS_CONFIG);
        try {
            Serde serde = (Serde)this.getConfiguredInstance(VALUE_SERDE_CLASS_CONFIG, Serde.class);
            if (serde == null) {
                valueSerdeConfigSetting = this.get(DEFAULT_VALUE_SERDE_CLASS_CONFIG);
                serde = (Serde)this.getConfiguredInstance(DEFAULT_VALUE_SERDE_CLASS_CONFIG, Serde.class);
            }
            serde.configure(this.originals(), false);
            return serde;
        }
        catch (Exception e) {
            throw new StreamsException(String.format("Failed to configure value serde %s", valueSerdeConfigSetting), e);
        }
    }

    public TimestampExtractor defaultTimestampExtractor() {
        TimestampExtractor timestampExtractor = (TimestampExtractor)this.getConfiguredInstance(TIMESTAMP_EXTRACTOR_CLASS_CONFIG, TimestampExtractor.class);
        if (timestampExtractor == null) {
            return (TimestampExtractor)this.getConfiguredInstance(DEFAULT_TIMESTAMP_EXTRACTOR_CLASS_CONFIG, TimestampExtractor.class);
        }
        return timestampExtractor;
    }

    private Map<String, Object> clientProps(Set<String> configNames, Map<String, Object> originals) {
        HashMap<String, Object> parsed = new HashMap<String, Object>();
        for (String configName : configNames) {
            if (!originals.containsKey(configName)) continue;
            parsed.put(configName, originals.get(configName));
        }
        return parsed;
    }

    public static void main(String[] args) {
        System.out.println(CONFIG.toHtmlTable());
    }

    static {
        HashMap<Object, Object> tempProducerDefaultOverrides = new HashMap<String, Object>();
        tempProducerDefaultOverrides.put("linger.ms", "100");
        tempProducerDefaultOverrides.put("retries", 10);
        PRODUCER_DEFAULT_OVERRIDES = Collections.unmodifiableMap(tempProducerDefaultOverrides);
        tempProducerDefaultOverrides = new HashMap<String, Object>(PRODUCER_DEFAULT_OVERRIDES);
        tempProducerDefaultOverrides.put("retries", Integer.MAX_VALUE);
        tempProducerDefaultOverrides.put("enable.idempotence", true);
        tempProducerDefaultOverrides.put("max.in.flight.requests.per.connection", 1);
        PRODUCER_EOS_OVERRIDES = Collections.unmodifiableMap(tempProducerDefaultOverrides);
        HashMap<Object, Object> tempConsumerDefaultOverrides = new HashMap<String, Object>();
        tempConsumerDefaultOverrides.put("max.poll.records", "1000");
        tempConsumerDefaultOverrides.put("auto.offset.reset", "earliest");
        tempConsumerDefaultOverrides.put("enable.auto.commit", "false");
        tempConsumerDefaultOverrides.put("internal.leave.group.on.close", false);
        tempConsumerDefaultOverrides.put("max.poll.interval.ms", Integer.toString(Integer.MAX_VALUE));
        CONSUMER_DEFAULT_OVERRIDES = Collections.unmodifiableMap(tempConsumerDefaultOverrides);
        tempConsumerDefaultOverrides = new HashMap<String, Object>(CONSUMER_DEFAULT_OVERRIDES);
        tempConsumerDefaultOverrides.put("isolation.level", IsolationLevel.READ_COMMITTED.name().toLowerCase(Locale.ROOT));
        CONSUMER_EOS_OVERRIDES = Collections.unmodifiableMap(tempConsumerDefaultOverrides);
    }

    public static class InternalConfig {
        public static final String STREAM_THREAD_INSTANCE = "__stream.thread.instance__";
    }
}

