/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.WindowedSerdes;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.junit.Assert;
import org.junit.Test;

public class WindowedSerdesTest {
    private final String topic = "sample";

    @Test
    public void testTimeWindowSerdeFrom() {
        Windowed timeWindowed = new Windowed((Object)10, (Window)new TimeWindow(0L, Long.MAX_VALUE));
        Serde timeWindowedSerde = WindowedSerdes.timeWindowedSerdeFrom(Integer.class);
        byte[] bytes = timeWindowedSerde.serializer().serialize("sample", (Object)timeWindowed);
        Windowed windowed = (Windowed)timeWindowedSerde.deserializer().deserialize("sample", bytes);
        Assert.assertEquals((Object)timeWindowed, (Object)windowed);
    }

    @Test
    public void testSessionWindowedSerdeFrom() {
        Windowed sessionWindowed = new Windowed((Object)10, (Window)new SessionWindow(0L, 1L));
        Serde sessionWindowedSerde = WindowedSerdes.sessionWindowedSerdeFrom(Integer.class);
        byte[] bytes = sessionWindowedSerde.serializer().serialize("sample", (Object)sessionWindowed);
        Windowed windowed = (Windowed)sessionWindowedSerde.deserializer().deserialize("sample", bytes);
        Assert.assertEquals((Object)sessionWindowed, (Object)windowed);
    }
}

