/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableKTableRightJoin;
import org.apache.kafka.streams.processor.MockProcessorContext;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.testutil.LogCaptureAppender;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class KTableKTableRightJoinTest {
    @Test
    public void shouldLogAndMeterSkippedRecordsDueToNullLeftKey() {
        StreamsBuilder builder = new StreamsBuilder();
        Processor join = new KTableKTableRightJoin((KTableImpl)builder.table("left", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String())), (KTableImpl)builder.table("right", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String())), null).get();
        MockProcessorContext context = new MockProcessorContext();
        context.setRecordMetadata("left", -1, -2L, null, -3L);
        join.init((ProcessorContext)context);
        LogCaptureAppender appender = LogCaptureAppender.createAndRegister();
        join.process(null, (Object)new Change((Object)"new", (Object)"old"));
        LogCaptureAppender.unregister(appender);
        Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByName(context.metrics().metrics(), "skipped-records-total", "stream-metrics").metricValue());
        MatcherAssert.assertThat(appender.getMessages(), (Matcher)CoreMatchers.hasItem((Object)"Skipping record due to null key. change=[(new<-old)] topic=[left] partition=[-1] offset=[-2]"));
    }
}

