/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Properties;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.TopologyTestDriverWrapper;
import org.apache.kafka.streams.TopologyWrapper;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.test.ConsumerRecordFactory;
import org.apache.kafka.test.MockProcessor;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class KTableMapValuesTest {
    private final Consumed<String, String> consumed = Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String());
    private final Produced<String, String> produced = Produced.with((Serde)Serdes.String(), (Serde)Serdes.String());
    private final ConsumerRecordFactory<String, String> recordFactory = new ConsumerRecordFactory((Serializer)new StringSerializer(), (Serializer)new StringSerializer());
    private final Properties props = StreamsTestUtils.topologyTestConfig(Serdes.String(), Serdes.String());

    private void doTestKTable(StreamsBuilder builder, String topic1, MockProcessorSupplier<String, Integer> supplier) {
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"A", (Object)"1"));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"B", (Object)"2"));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"C", (Object)"3"));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"D", (Object)"4"));
            Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"A:1", "B:2", "C:3", "D:4"}), supplier.theCapturedProcessor().processed);
        }
    }

    @Test
    public void testKTable() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        KTable table1 = builder.table("topic1", this.consumed);
        KTable table2 = table1.mapValues((ValueMapper)new ValueMapper<CharSequence, Integer>(){

            public Integer apply(CharSequence value) {
                return value.charAt(0) - 48;
            }
        });
        MockProcessorSupplier<String, Integer> supplier = new MockProcessorSupplier<String, Integer>();
        table2.toStream().process(supplier, new String[0]);
        this.doTestKTable(builder, "topic1", supplier);
    }

    @Test
    public void testQueryableKTable() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        KTable table1 = builder.table("topic1", this.consumed);
        KTable table2 = table1.mapValues((ValueMapper)new ValueMapper<CharSequence, Integer>(){

            public Integer apply(CharSequence value) {
                return value.charAt(0) - 48;
            }
        }, Materialized.as((String)"anyName").withValueSerde(Serdes.Integer()));
        MockProcessorSupplier<String, Integer> supplier = new MockProcessorSupplier<String, Integer>();
        table2.toStream().process(supplier, new String[0]);
        this.doTestKTable(builder, "topic1", supplier);
    }

    private void doTestValueGetter(StreamsBuilder builder, String topic1, KTableImpl<String, String, String> table1, KTableImpl<String, String, Integer> table2, KTableImpl<String, Integer, Integer> table3, KTableImpl<String, String, String> table4) {
        Topology topology = builder.build();
        KTableValueGetterSupplier getterSupplier1 = table1.valueGetterSupplier();
        KTableValueGetterSupplier getterSupplier2 = table2.valueGetterSupplier();
        KTableValueGetterSupplier getterSupplier3 = table3.valueGetterSupplier();
        KTableValueGetterSupplier getterSupplier4 = table4.valueGetterSupplier();
        InternalTopologyBuilder topologyBuilder = TopologyWrapper.getInternalTopologyBuilder(topology);
        topologyBuilder.connectProcessorAndStateStores(table1.name, getterSupplier1.storeNames());
        topologyBuilder.connectProcessorAndStateStores(table2.name, getterSupplier2.storeNames());
        topologyBuilder.connectProcessorAndStateStores(table3.name, getterSupplier3.storeNames());
        topologyBuilder.connectProcessorAndStateStores(table4.name, getterSupplier4.storeNames());
        try (TopologyTestDriverWrapper driver = new TopologyTestDriverWrapper(builder.build(), this.props);){
            KTableValueGetter getter1 = getterSupplier1.get();
            KTableValueGetter getter2 = getterSupplier2.get();
            KTableValueGetter getter3 = getterSupplier3.get();
            KTableValueGetter getter4 = getterSupplier4.get();
            getter1.init(driver.setCurrentNodeForProcessorContext(table1.name));
            getter2.init(driver.setCurrentNodeForProcessorContext(table2.name));
            getter3.init(driver.setCurrentNodeForProcessorContext(table3.name));
            getter4.init(driver.setCurrentNodeForProcessorContext(table4.name));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"A", (Object)"01"));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"B", (Object)"01"));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"C", (Object)"01"));
            Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"A"));
            Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"B"));
            Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"C"));
            Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"A"));
            Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"B"));
            Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"C"));
            Assert.assertNull((Object)getter3.get((Object)"A"));
            Assert.assertNull((Object)getter3.get((Object)"B"));
            Assert.assertNull((Object)getter3.get((Object)"C"));
            Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"A"));
            Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"B"));
            Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"C"));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"A", (Object)"02"));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"B", (Object)"02"));
            Assert.assertEquals((Object)"02", (Object)getter1.get((Object)"A"));
            Assert.assertEquals((Object)"02", (Object)getter1.get((Object)"B"));
            Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"C"));
            Assert.assertEquals((Object)new Integer(2), (Object)getter2.get((Object)"A"));
            Assert.assertEquals((Object)new Integer(2), (Object)getter2.get((Object)"B"));
            Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"C"));
            Assert.assertEquals((Object)new Integer(2), (Object)getter3.get((Object)"A"));
            Assert.assertEquals((Object)new Integer(2), (Object)getter3.get((Object)"B"));
            Assert.assertNull((Object)getter3.get((Object)"C"));
            Assert.assertEquals((Object)"02", (Object)getter4.get((Object)"A"));
            Assert.assertEquals((Object)"02", (Object)getter4.get((Object)"B"));
            Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"C"));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"A", (Object)"03"));
            Assert.assertEquals((Object)"03", (Object)getter1.get((Object)"A"));
            Assert.assertEquals((Object)"02", (Object)getter1.get((Object)"B"));
            Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"C"));
            Assert.assertEquals((Object)new Integer(3), (Object)getter2.get((Object)"A"));
            Assert.assertEquals((Object)new Integer(2), (Object)getter2.get((Object)"B"));
            Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"C"));
            Assert.assertNull((Object)getter3.get((Object)"A"));
            Assert.assertEquals((Object)new Integer(2), (Object)getter3.get((Object)"B"));
            Assert.assertNull((Object)getter3.get((Object)"C"));
            Assert.assertEquals((Object)"03", (Object)getter4.get((Object)"A"));
            Assert.assertEquals((Object)"02", (Object)getter4.get((Object)"B"));
            Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"C"));
            driver.pipeInput(this.recordFactory.create(topic1, (Object)"A", (Object)null));
            Assert.assertNull((Object)getter1.get((Object)"A"));
            Assert.assertEquals((Object)"02", (Object)getter1.get((Object)"B"));
            Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"C"));
            Assert.assertNull((Object)getter2.get((Object)"A"));
            Assert.assertEquals((Object)new Integer(2), (Object)getter2.get((Object)"B"));
            Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"C"));
            Assert.assertNull((Object)getter3.get((Object)"A"));
            Assert.assertEquals((Object)new Integer(2), (Object)getter3.get((Object)"B"));
            Assert.assertNull((Object)getter3.get((Object)"C"));
            Assert.assertNull((Object)getter4.get((Object)"A"));
            Assert.assertEquals((Object)"02", (Object)getter4.get((Object)"B"));
            Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"C"));
        }
    }

    @Test
    public void testValueGetter() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        String topic2 = "topic2";
        KTableImpl table1 = (KTableImpl)builder.table("topic1", this.consumed);
        KTableImpl table2 = (KTableImpl)table1.mapValues((ValueMapper)new ValueMapper<String, Integer>(){

            public Integer apply(String value) {
                return new Integer(value);
            }
        });
        KTableImpl table3 = (KTableImpl)table2.filter((Predicate)new Predicate<String, Integer>(){

            public boolean test(String key, Integer value) {
                return value % 2 == 0;
            }
        });
        table1.toStream().to("topic2", this.produced);
        KTableImpl table4 = (KTableImpl)builder.table("topic2", this.consumed);
        this.doTestValueGetter(builder, "topic1", (KTableImpl<String, String, String>)table1, (KTableImpl<String, String, Integer>)table2, (KTableImpl<String, Integer, Integer>)table3, (KTableImpl<String, String, String>)table4);
    }

    @Test
    public void testQueryableValueGetter() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        String topic2 = "topic2";
        String storeName2 = "anyMapName";
        String storeName3 = "anyFilterName";
        KTableImpl table1 = (KTableImpl)builder.table("topic1", this.consumed);
        KTableImpl table2 = (KTableImpl)table1.mapValues((ValueMapper)new ValueMapper<String, Integer>(){

            public Integer apply(String value) {
                return new Integer(value);
            }
        }, Materialized.as((String)"anyMapName").withValueSerde(Serdes.Integer()));
        KTableImpl table3 = (KTableImpl)table2.filter((Predicate)new Predicate<String, Integer>(){

            public boolean test(String key, Integer value) {
                return value % 2 == 0;
            }
        }, Materialized.as((String)"anyFilterName").withValueSerde(Serdes.Integer()));
        table1.toStream().to("topic2", this.produced);
        KTableImpl table4 = (KTableImpl)builder.table("topic2", this.consumed);
        this.doTestValueGetter(builder, "topic1", (KTableImpl<String, String, String>)table1, (KTableImpl<String, String, Integer>)table2, (KTableImpl<String, Integer, Integer>)table3, (KTableImpl<String, String, String>)table4);
    }

    @Test
    public void testNotSendingOldValue() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        KTableImpl table1 = (KTableImpl)builder.table("topic1", this.consumed);
        KTableImpl table2 = (KTableImpl)table1.mapValues((ValueMapper)new ValueMapper<String, Integer>(){

            public Integer apply(String value) {
                return new Integer(value);
            }
        });
        MockProcessorSupplier supplier = new MockProcessorSupplier();
        Topology topology = builder.build().addProcessor("proc", supplier, new String[]{table2.name});
        try (TopologyTestDriver driver = new TopologyTestDriver(topology, this.props);){
            MockProcessor proc = supplier.theCapturedProcessor();
            Assert.assertFalse((boolean)table1.sendingOldValueEnabled());
            Assert.assertFalse((boolean)table2.sendingOldValueEnabled());
            driver.pipeInput(this.recordFactory.create("topic1", (Object)"A", (Object)"01"));
            driver.pipeInput(this.recordFactory.create("topic1", (Object)"B", (Object)"01"));
            driver.pipeInput(this.recordFactory.create("topic1", (Object)"C", (Object)"01"));
            proc.checkAndClearProcessResult("A:(1<-null)", "B:(1<-null)", "C:(1<-null)");
            driver.pipeInput(this.recordFactory.create("topic1", (Object)"A", (Object)"02"));
            driver.pipeInput(this.recordFactory.create("topic1", (Object)"B", (Object)"02"));
            proc.checkAndClearProcessResult("A:(2<-null)", "B:(2<-null)");
            driver.pipeInput(this.recordFactory.create("topic1", (Object)"A", (Object)"03"));
            proc.checkAndClearProcessResult("A:(3<-null)");
            driver.pipeInput(this.recordFactory.create("topic1", (Object)"A", (Object)null));
            proc.checkAndClearProcessResult("A:(null<-null)");
        }
    }

    @Test
    public void testSendingOldValue() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        KTableImpl table1 = (KTableImpl)builder.table("topic1", this.consumed);
        KTableImpl table2 = (KTableImpl)table1.mapValues((ValueMapper)new ValueMapper<String, Integer>(){

            public Integer apply(String value) {
                return new Integer(value);
            }
        });
        table2.enableSendingOldValues();
        MockProcessorSupplier supplier = new MockProcessorSupplier();
        builder.build().addProcessor("proc", supplier, new String[]{table2.name});
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            MockProcessor proc = supplier.theCapturedProcessor();
            Assert.assertTrue((boolean)table1.sendingOldValueEnabled());
            Assert.assertTrue((boolean)table2.sendingOldValueEnabled());
            driver.pipeInput(this.recordFactory.create("topic1", (Object)"A", (Object)"01"));
            driver.pipeInput(this.recordFactory.create("topic1", (Object)"B", (Object)"01"));
            driver.pipeInput(this.recordFactory.create("topic1", (Object)"C", (Object)"01"));
            proc.checkAndClearProcessResult("A:(1<-null)", "B:(1<-null)", "C:(1<-null)");
            driver.pipeInput(this.recordFactory.create("topic1", (Object)"A", (Object)"02"));
            driver.pipeInput(this.recordFactory.create("topic1", (Object)"B", (Object)"02"));
            proc.checkAndClearProcessResult("A:(2<-1)", "B:(2<-1)");
            driver.pipeInput(this.recordFactory.create("topic1", (Object)"A", (Object)"03"));
            proc.checkAndClearProcessResult("A:(3<-2)");
            driver.pipeInput(this.recordFactory.create("topic1", (Object)"A", (Object)null));
            proc.checkAndClearProcessResult("A:(null<-3)");
        }
    }
}

