/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.CompositeReadOnlyKeyValueStore;
import org.apache.kafka.streams.state.internals.StateStoreProvider;
import org.apache.kafka.streams.state.internals.WrappingStoreProvider;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.NoOpReadOnlyStore;
import org.apache.kafka.test.NoOpRecordCollector;
import org.apache.kafka.test.StateStoreProviderStub;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompositeReadOnlyKeyValueStoreTest {
    private final String storeName = "my-store";
    private final String storeNameA = "my-storeA";
    private StateStoreProviderStub stubProviderTwo;
    private KeyValueStore<String, String> stubOneUnderlying;
    private KeyValueStore<String, String> otherUnderlyingStore;
    private CompositeReadOnlyKeyValueStore<String, String> theStore;

    @Before
    public void before() {
        StateStoreProviderStub stubProviderOne = new StateStoreProviderStub(false);
        this.stubProviderTwo = new StateStoreProviderStub(false);
        this.stubOneUnderlying = this.newStoreInstance();
        stubProviderOne.addStore("my-store", (StateStore)this.stubOneUnderlying);
        this.otherUnderlyingStore = this.newStoreInstance();
        stubProviderOne.addStore("other-store", (StateStore)this.otherUnderlyingStore);
        this.theStore = new CompositeReadOnlyKeyValueStore((StateStoreProvider)new WrappingStoreProvider(Arrays.asList(stubProviderOne, this.stubProviderTwo)), QueryableStoreTypes.keyValueStore(), "my-store");
    }

    private KeyValueStore<String, String> newStoreInstance() {
        KeyValueStore store = (KeyValueStore)Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"my-store"), (Serde)Serdes.String(), (Serde)Serdes.String()).build();
        store.init((ProcessorContext)new InternalMockProcessorContext(new StateSerdes(ProcessorStateManager.storeChangelogTopic((String)"appId", (String)"my-store"), Serdes.String(), Serdes.String()), new NoOpRecordCollector()), (StateStore)store);
        return store;
    }

    @Test
    public void shouldReturnNullIfKeyDoesntExist() {
        Assert.assertNull((Object)this.theStore.get((Object)"whatever"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnGetNullKey() {
        this.theStore.get(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnRangeNullFromKey() {
        this.theStore.range(null, (Object)"to");
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnRangeNullToKey() {
        this.theStore.range((Object)"from", null);
    }

    @Test
    public void shouldReturnValueIfExists() {
        this.stubOneUnderlying.put((Object)"key", (Object)"value");
        Assert.assertEquals((Object)"value", (Object)this.theStore.get((Object)"key"));
    }

    @Test
    public void shouldNotGetValuesFromOtherStores() {
        this.otherUnderlyingStore.put((Object)"otherKey", (Object)"otherValue");
        Assert.assertNull((Object)this.theStore.get((Object)"otherKey"));
    }

    @Test
    public void shouldThrowNoSuchElementExceptionWhileNext() {
        this.stubOneUnderlying.put((Object)"a", (Object)"1");
        KeyValueIterator keyValueIterator = this.theStore.range((Object)"a", (Object)"b");
        keyValueIterator.next();
        try {
            keyValueIterator.next();
            Assert.fail((String)"Should have thrown NoSuchElementException with next()");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowNoSuchElementExceptionWhilePeekNext() {
        this.stubOneUnderlying.put((Object)"a", (Object)"1");
        KeyValueIterator keyValueIterator = this.theStore.range((Object)"a", (Object)"b");
        keyValueIterator.next();
        try {
            keyValueIterator.peekNextKey();
            Assert.fail((String)"Should have thrown NoSuchElementException with peekNextKey()");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowUnsupportedOperationExceptionWhileRemove() {
        KeyValueIterator keyValueIterator = this.theStore.all();
        try {
            keyValueIterator.remove();
            Assert.fail((String)"Should have thrown UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowUnsupportedOperationExceptionWhileRange() {
        this.stubOneUnderlying.put((Object)"a", (Object)"1");
        this.stubOneUnderlying.put((Object)"b", (Object)"1");
        KeyValueIterator keyValueIterator = this.theStore.range((Object)"a", (Object)"b");
        try {
            keyValueIterator.remove();
            Assert.fail((String)"Should have thrown UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFindValueForKeyWhenMultiStores() {
        KeyValueStore<String, String> cache = this.newStoreInstance();
        this.stubProviderTwo.addStore("my-store", (StateStore)cache);
        cache.put((Object)"key-two", (Object)"key-two-value");
        this.stubOneUnderlying.put((Object)"key-one", (Object)"key-one-value");
        Assert.assertEquals((Object)"key-two-value", (Object)this.theStore.get((Object)"key-two"));
        Assert.assertEquals((Object)"key-one-value", (Object)this.theStore.get((Object)"key-one"));
    }

    @Test
    public void shouldSupportRange() {
        this.stubOneUnderlying.put((Object)"a", (Object)"a");
        this.stubOneUnderlying.put((Object)"b", (Object)"b");
        this.stubOneUnderlying.put((Object)"c", (Object)"c");
        List results = StreamsTestUtils.toList(this.theStore.range((Object)"a", (Object)"b"));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"a", (Object)"a")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"b", (Object)"b")));
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void shouldSupportRangeAcrossMultipleKVStores() {
        KeyValueStore<String, String> cache = this.newStoreInstance();
        this.stubProviderTwo.addStore("my-store", (StateStore)cache);
        this.stubOneUnderlying.put((Object)"a", (Object)"a");
        this.stubOneUnderlying.put((Object)"b", (Object)"b");
        this.stubOneUnderlying.put((Object)"z", (Object)"z");
        cache.put((Object)"c", (Object)"c");
        cache.put((Object)"d", (Object)"d");
        cache.put((Object)"x", (Object)"x");
        List results = StreamsTestUtils.toList(this.theStore.range((Object)"a", (Object)"e"));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"a", (Object)"a")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"b", (Object)"b")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"c", (Object)"c")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"d", (Object)"d")));
        Assert.assertEquals((long)4L, (long)results.size());
    }

    @Test
    public void shouldSupportAllAcrossMultipleStores() {
        KeyValueStore<String, String> cache = this.newStoreInstance();
        this.stubProviderTwo.addStore("my-store", (StateStore)cache);
        this.stubOneUnderlying.put((Object)"a", (Object)"a");
        this.stubOneUnderlying.put((Object)"b", (Object)"b");
        this.stubOneUnderlying.put((Object)"z", (Object)"z");
        cache.put((Object)"c", (Object)"c");
        cache.put((Object)"d", (Object)"d");
        cache.put((Object)"x", (Object)"x");
        List results = StreamsTestUtils.toList(this.theStore.all());
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"a", (Object)"a")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"b", (Object)"b")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"c", (Object)"c")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"d", (Object)"d")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"x", (Object)"x")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"z", (Object)"z")));
        Assert.assertEquals((long)6L, (long)results.size());
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowInvalidStoreExceptionDuringRebalance() {
        this.rebalancing().get((Object)"anything");
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowInvalidStoreExceptionOnApproximateNumEntriesDuringRebalance() {
        this.rebalancing().approximateNumEntries();
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowInvalidStoreExceptionOnRangeDuringRebalance() {
        this.rebalancing().range((Object)"anything", (Object)"something");
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowInvalidStoreExceptionOnAllDuringRebalance() {
        this.rebalancing().all();
    }

    @Test
    public void shouldGetApproximateEntriesAcrossAllStores() {
        KeyValueStore<String, String> cache = this.newStoreInstance();
        this.stubProviderTwo.addStore("my-store", (StateStore)cache);
        this.stubOneUnderlying.put((Object)"a", (Object)"a");
        this.stubOneUnderlying.put((Object)"b", (Object)"b");
        this.stubOneUnderlying.put((Object)"z", (Object)"z");
        cache.put((Object)"c", (Object)"c");
        cache.put((Object)"d", (Object)"d");
        cache.put((Object)"x", (Object)"x");
        Assert.assertEquals((long)6L, (long)this.theStore.approximateNumEntries());
    }

    @Test
    public void shouldReturnLongMaxValueOnOverflow() {
        this.stubProviderTwo.addStore("my-store", new NoOpReadOnlyStore<Object, Object>(){

            @Override
            public long approximateNumEntries() {
                return Long.MAX_VALUE;
            }
        });
        this.stubOneUnderlying.put((Object)"overflow", (Object)"me");
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.theStore.approximateNumEntries());
    }

    @Test
    public void shouldReturnLongMaxValueOnUnderflow() {
        this.stubProviderTwo.addStore("my-store", new NoOpReadOnlyStore<Object, Object>(){

            @Override
            public long approximateNumEntries() {
                return Long.MAX_VALUE;
            }
        });
        this.stubProviderTwo.addStore("my-storeA", new NoOpReadOnlyStore<Object, Object>(){

            @Override
            public long approximateNumEntries() {
                return Long.MAX_VALUE;
            }
        });
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.theStore.approximateNumEntries());
    }

    private CompositeReadOnlyKeyValueStore<Object, Object> rebalancing() {
        return new CompositeReadOnlyKeyValueStore((StateStoreProvider)new WrappingStoreProvider(Collections.singletonList(new StateStoreProviderStub(true))), QueryableStoreTypes.keyValueStore(), "my-store");
    }
}

