/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.MeteredKeyValueBytesStore;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.MockType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class MeteredKeyValueBytesStoreTest {
    private final TaskId taskId = new TaskId(0, 0);
    private final Map<String, String> tags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)"test"), Utils.mkEntry((Object)"task-id", (Object)this.taskId.toString()), Utils.mkEntry((Object)"scope-id", (Object)"metered")});
    @Mock(type=MockType.NICE)
    private KeyValueStore<Bytes, byte[]> inner;
    @Mock(type=MockType.NICE)
    private ProcessorContext context;
    private MeteredKeyValueBytesStore<String, String> metered;
    private final String key = "key";
    private final Bytes keyBytes = Bytes.wrap((byte[])"key".getBytes());
    private final String value = "value";
    private final byte[] valueBytes = "value".getBytes();
    private final Metrics metrics = new Metrics();

    @Before
    public void before() {
        this.metered = new MeteredKeyValueBytesStore(this.inner, "scope", (Time)new MockTime(), Serdes.String(), Serdes.String());
        this.metrics.config().recordLevel(Sensor.RecordingLevel.DEBUG);
        EasyMock.expect((Object)this.context.metrics()).andReturn((Object)new MockStreamsMetrics(this.metrics));
        EasyMock.expect((Object)this.context.taskId()).andReturn((Object)this.taskId);
        EasyMock.expect((Object)this.inner.name()).andReturn((Object)"metered").anyTimes();
    }

    private void init() {
        EasyMock.replay((Object[])new Object[]{this.inner, this.context});
        this.metered.init(this.context, this.metered);
    }

    @Test
    public void shouldWriteBytesToInnerStoreAndRecordPutMetric() {
        this.inner.put(EasyMock.eq((Object)this.keyBytes), (Object)EasyMock.aryEq((byte[])this.valueBytes));
        EasyMock.expectLastCall();
        this.init();
        this.metered.put((Object)"key", (Object)"value");
        KafkaMetric metric = this.metric("put-rate");
        Assert.assertTrue((metric.value() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldGetBytesFromInnerStoreAndReturnGetMetric() {
        EasyMock.expect((Object)this.inner.get((Object)this.keyBytes)).andReturn((Object)this.valueBytes);
        this.init();
        Assert.assertThat((Object)this.metered.get((Object)"key"), (Matcher)CoreMatchers.equalTo((Object)"value"));
        KafkaMetric metric = this.metric("get-rate");
        Assert.assertTrue((metric.value() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldPutIfAbsentAndRecordPutIfAbsentMetric() {
        EasyMock.expect((Object)this.inner.putIfAbsent(EasyMock.eq((Object)this.keyBytes), (Object)EasyMock.aryEq((byte[])this.valueBytes))).andReturn(null);
        this.init();
        this.metered.putIfAbsent((Object)"key", (Object)"value");
        KafkaMetric metric = this.metric("put-if-absent-rate");
        Assert.assertTrue((metric.value() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    private KafkaMetric metric(String name) {
        return this.metrics.metric(new MetricName(name, "stream-scope-metrics", "", this.tags));
    }

    @Test
    public void shouldPutAllToInnerStoreAndRecordPutAllMetric() {
        this.inner.putAll((List)EasyMock.anyObject(List.class));
        EasyMock.expectLastCall();
        this.init();
        this.metered.putAll(Collections.singletonList(KeyValue.pair((Object)"key", (Object)"value")));
        KafkaMetric metric = this.metric("put-all-rate");
        Assert.assertTrue((metric.value() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldDeleteFromInnerStoreAndRecordDeleteMetric() {
        EasyMock.expect((Object)this.inner.delete((Object)this.keyBytes)).andReturn((Object)this.valueBytes);
        this.init();
        this.metered.delete((Object)"key");
        KafkaMetric metric = this.metric("delete-rate");
        Assert.assertTrue((metric.value() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldGetRangeFromInnerStoreAndRecordRangeMetric() {
        EasyMock.expect((Object)this.inner.range((Object)this.keyBytes, (Object)this.keyBytes)).andReturn(new KeyValueIteratorStub(Collections.singletonList(KeyValue.pair((Object)this.keyBytes, (Object)this.valueBytes)).iterator()));
        this.init();
        KeyValueIterator iterator = this.metered.range((Object)"key", (Object)"key");
        Assert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)"value"));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("range-rate");
        Assert.assertTrue((metric.value() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldGetAllFromInnerStoreAndRecordAllMetric() {
        EasyMock.expect((Object)this.inner.all()).andReturn(new KeyValueIteratorStub(Collections.singletonList(KeyValue.pair((Object)this.keyBytes, (Object)this.valueBytes)).iterator()));
        this.init();
        KeyValueIterator iterator = this.metered.all();
        Assert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)"value"));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric(new MetricName("all-rate", "stream-scope-metrics", "", this.tags));
        Assert.assertTrue((metric.value() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldFlushInnerWhenFlushTimeRecords() {
        this.inner.flush();
        EasyMock.expectLastCall().once();
        this.init();
        this.metered.flush();
        KafkaMetric metric = this.metric("flush-rate");
        Assert.assertTrue((metric.value() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    private KafkaMetric metric(MetricName metricName) {
        return this.metrics.metric(metricName);
    }
}

