/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serializer;

public class MockRestoreConsumer
extends MockConsumer<byte[], byte[]> {
    private final Serializer<Integer> serializer = new IntegerSerializer();
    private TopicPartition assignedPartition = null;
    private long seekOffset = -1L;
    private long endOffset = 0L;
    private long currentOffset = 0L;
    private ArrayList<ConsumerRecord<byte[], byte[]>> recordBuffer = new ArrayList();

    public MockRestoreConsumer() {
        super(OffsetResetStrategy.EARLIEST);
        this.reset();
    }

    public void reset() {
        this.assignedPartition = null;
        this.seekOffset = -1L;
        this.endOffset = 0L;
        this.recordBuffer.clear();
    }

    public void bufferRecord(ConsumerRecord<Integer, Integer> record) {
        this.recordBuffer.add((ConsumerRecord<byte[], byte[]>)new ConsumerRecord(record.topic(), record.partition(), record.offset(), 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)this.serializer.serialize(record.topic(), record.key()), (Object)this.serializer.serialize(record.topic(), record.value())));
        this.endOffset = record.offset();
        super.updateEndOffsets(Collections.singletonMap(this.assignedPartition, this.endOffset));
    }

    public synchronized void assign(Collection<TopicPartition> partitions) {
        int numPartitions = partitions.size();
        if (numPartitions > 1) {
            throw new IllegalArgumentException("RestoreConsumer: more than one partition specified");
        }
        if (numPartitions == 1) {
            if (this.assignedPartition != null) {
                throw new IllegalStateException("RestoreConsumer: partition already assigned");
            }
            this.assignedPartition = partitions.iterator().next();
            super.updateBeginningOffsets(Collections.singletonMap(this.assignedPartition, 0L));
        }
        super.assign(partitions);
    }

    public ConsumerRecords<byte[], byte[]> poll(Duration timeout) {
        for (ConsumerRecord<byte[], byte[]> record : this.recordBuffer) {
            super.addRecord(record);
        }
        this.recordBuffer.clear();
        ConsumerRecords records = super.poll(timeout);
        List partitionRecords = records.records(this.assignedPartition);
        for (ConsumerRecord record : partitionRecords) {
            this.currentOffset = record.offset();
        }
        return records;
    }

    public synchronized long position(TopicPartition partition) {
        if (!partition.equals((Object)this.assignedPartition)) {
            throw new IllegalStateException("RestoreConsumer: unassigned partition");
        }
        return this.currentOffset;
    }

    public synchronized void seek(TopicPartition partition, long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("RestoreConsumer: offset should not be negative");
        }
        if (this.seekOffset >= 0L) {
            throw new IllegalStateException("RestoreConsumer: offset already seeked");
        }
        this.seekOffset = offset;
        this.currentOffset = offset;
        super.seek(partition, offset);
    }

    public synchronized void seekToBeginning(Collection<TopicPartition> partitions) {
        if (partitions.size() != 1) {
            throw new IllegalStateException("RestoreConsumer: other than one partition specified");
        }
        for (TopicPartition partition : partitions) {
            if (partition.equals((Object)this.assignedPartition)) continue;
            throw new IllegalStateException("RestoreConsumer: seek-to-end not on the assigned partition");
        }
        this.currentOffset = 0L;
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
        if (partitions.size() != 1) {
            throw new IllegalStateException("RestoreConsumer: other than one partition specified");
        }
        for (TopicPartition partition : partitions) {
            if (partition.equals((Object)this.assignedPartition)) continue;
            throw new IllegalStateException("RestoreConsumer: seek-to-end not on the assigned partition");
        }
        this.currentOffset = this.endOffset;
        return super.endOffsets(partitions);
    }
}

