/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.internals;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public final class ApiUtils {
    private ApiUtils() {
    }

    public static long validateMillisecondDuration(Duration duration, String name) {
        try {
            if (duration == null) {
                throw new IllegalArgumentException("[" + Objects.toString(name) + "] shouldn't be null.");
            }
            return duration.toMillis();
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException("[" + name + "] can't be converted to milliseconds. ", e);
        }
    }

    public static long validateMillisecondInstant(Instant instant, String name) {
        try {
            if (instant == null) {
                throw new IllegalArgumentException("[" + name + "] shouldn't be null.");
            }
            return instant.toEpochMilli();
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException("[" + name + "] can't be converted to milliseconds. ", e);
        }
    }
}

