/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import java.util.Objects;
import org.apache.kafka.streams.internals.ApiUtils;

public final class SessionWindows {
    private final long gapMs;
    private final long maintainDurationMs;
    private final Duration grace;

    private SessionWindows(long gapMs, long maintainDurationMs, Duration grace) {
        this.gapMs = gapMs;
        this.maintainDurationMs = maintainDurationMs;
        this.grace = grace;
    }

    @Deprecated
    public static SessionWindows with(long inactivityGapMs) {
        if (inactivityGapMs <= 0L) {
            throw new IllegalArgumentException("Gap time (inactivityGapMs) cannot be zero or negative.");
        }
        return new SessionWindows(inactivityGapMs, 86400000L, null);
    }

    public static SessionWindows with(Duration inactivityGap) {
        ApiUtils.validateMillisecondDuration(inactivityGap, "inactivityGap");
        return SessionWindows.with(inactivityGap.toMillis());
    }

    @Deprecated
    public SessionWindows until(long durationMs) throws IllegalArgumentException {
        if (durationMs < this.gapMs) {
            throw new IllegalArgumentException("Window retention time (durationMs) cannot be smaller than window gap.");
        }
        return new SessionWindows(this.gapMs, durationMs, this.grace);
    }

    public SessionWindows grace(Duration afterWindowEnd) throws IllegalArgumentException {
        ApiUtils.validateMillisecondDuration(afterWindowEnd, "afterWindowEnd");
        if (afterWindowEnd.toMillis() < 0L) {
            throw new IllegalArgumentException("Grace period must not be negative.");
        }
        return new SessionWindows(this.gapMs, this.maintainDurationMs, afterWindowEnd);
    }

    public long gracePeriodMs() {
        return this.grace != null ? this.grace.toMillis() : this.maintainMs() - this.inactivityGap();
    }

    public long inactivityGap() {
        return this.gapMs;
    }

    @Deprecated
    public long maintainMs() {
        return Math.max(this.maintainDurationMs, this.gapMs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionWindows that = (SessionWindows)o;
        return this.gapMs == that.gapMs && this.maintainDurationMs == that.maintainDurationMs && Objects.equals(this.grace, that.grace);
    }

    public int hashCode() {
        return Objects.hash(this.gapMs, this.maintainDurationMs, this.grace);
    }

    public String toString() {
        return "SessionWindows{gapMs=" + this.gapMs + ", maintainDurationMs=" + this.maintainDurationMs + ", grace=" + this.grace + '}';
    }
}

