/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;

public class ContextualRecord {
    private final byte[] value;
    private final ProcessorRecordContext recordContext;

    public ContextualRecord(byte[] value, ProcessorRecordContext recordContext) {
        this.value = value;
        this.recordContext = recordContext;
    }

    public ProcessorRecordContext recordContext() {
        return this.recordContext;
    }

    public byte[] value() {
        return this.value;
    }

    public long sizeBytes() {
        return (long)(this.value == null ? 0 : this.value.length) + this.recordContext.sizeBytes();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextualRecord that = (ContextualRecord)o;
        return Arrays.equals(this.value, that.value) && Objects.equals(this.recordContext, that.recordContext);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.recordContext);
    }
}

