/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.suppress.EagerBufferConfigImpl;
import org.apache.kafka.streams.kstream.internals.suppress.FinalResultsSuppressionBuilder;
import org.apache.kafka.streams.kstream.internals.suppress.StrictBufferConfigImpl;
import org.apache.kafka.streams.kstream.internals.suppress.SuppressedInternal;

public interface Suppressed<K> {
    public static Suppressed<Windowed> untilWindowCloses(StrictBufferConfig bufferConfig) {
        return new FinalResultsSuppressionBuilder<Windowed>(null, bufferConfig);
    }

    public static <K> Suppressed<K> untilTimeLimit(Duration timeToWaitForMoreEvents, BufferConfig bufferConfig) {
        return new SuppressedInternal(null, timeToWaitForMoreEvents, bufferConfig, null, false);
    }

    public Suppressed<K> withName(String var1);

    public static interface BufferConfig<BC extends BufferConfig<BC>> {
        public static BufferConfig<?> maxRecords(long recordLimit) {
            return new EagerBufferConfigImpl(recordLimit, Long.MAX_VALUE);
        }

        public BC withMaxRecords(long var1);

        public static BufferConfig<?> maxBytes(long byteLimit) {
            return new EagerBufferConfigImpl(Long.MAX_VALUE, byteLimit);
        }

        public BC withMaxBytes(long var1);

        public static StrictBufferConfig unbounded() {
            return new StrictBufferConfigImpl();
        }

        public StrictBufferConfig withNoBound();

        public StrictBufferConfig shutDownWhenFull();

        public BufferConfig emitEarlyWhenFull();
    }

    public static interface StrictBufferConfig
    extends BufferConfig<StrictBufferConfig> {
    }
}

