/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.OrderedBytes;
import org.apache.kafka.streams.state.internals.Segment;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.Segments;

public class WindowKeySchema
implements SegmentedBytesStore.KeySchema {
    private static final int SEQNUM_SIZE = 4;
    private static final int TIMESTAMP_SIZE = 8;
    private static final int SUFFIX_SIZE = 12;
    private static final byte[] MIN_SUFFIX = new byte[12];

    @Override
    public Bytes upperRange(Bytes key, long to) {
        byte[] maxSuffix = ByteBuffer.allocate(12).putLong(to).putInt(Integer.MAX_VALUE).array();
        return OrderedBytes.upperRange(key, maxSuffix);
    }

    @Override
    public Bytes lowerRange(Bytes key, long from) {
        return OrderedBytes.lowerRange(key, MIN_SUFFIX);
    }

    @Override
    public Bytes lowerRangeFixedSize(Bytes key, long from) {
        return WindowKeySchema.toStoreKeyBinary(key, Math.max(0L, from), 0);
    }

    @Override
    public Bytes upperRangeFixedSize(Bytes key, long to) {
        return WindowKeySchema.toStoreKeyBinary(key, to, Integer.MAX_VALUE);
    }

    @Override
    public long segmentTimestamp(Bytes key) {
        return WindowKeySchema.extractStoreTimestamp(key.get());
    }

    @Override
    public HasNextCondition hasNextCondition(Bytes binaryKeyFrom, Bytes binaryKeyTo, long from, long to) {
        return iterator -> {
            while (iterator.hasNext()) {
                Bytes bytes = (Bytes)iterator.peekNextKey();
                Bytes keyBytes = Bytes.wrap((byte[])WindowKeySchema.extractStoreKeyBytes(bytes.get()));
                long time = WindowKeySchema.extractStoreTimestamp(bytes.get());
                if (!(binaryKeyFrom != null && keyBytes.compareTo(binaryKeyFrom) < 0 || binaryKeyTo != null && keyBytes.compareTo(binaryKeyTo) > 0 || time < from || time > to)) {
                    return true;
                }
                iterator.next();
            }
            return false;
        };
    }

    @Override
    public <S extends Segment> List<S> segmentsToSearch(Segments<S> segments, long from, long to) {
        return segments.segments(from, to);
    }

    static TimeWindow timeWindowForSize(long startMs, long windowSize) {
        long endMs = startMs + windowSize;
        return new TimeWindow(startMs, endMs < 0L ? Long.MAX_VALUE : endMs);
    }

    public static <K> byte[] toBinary(Windowed<K> timeKey, Serializer<K> serializer, String topic) {
        byte[] bytes = serializer.serialize(topic, timeKey.key());
        ByteBuffer buf = ByteBuffer.allocate(bytes.length + 8);
        buf.put(bytes);
        buf.putLong(timeKey.window().start());
        return buf.array();
    }

    public static <K> Windowed<K> from(byte[] binaryKey, long windowSize, Deserializer<K> deserializer, String topic) {
        byte[] bytes = new byte[binaryKey.length - 8];
        System.arraycopy(binaryKey, 0, bytes, 0, bytes.length);
        Object key = deserializer.deserialize(topic, bytes);
        Window window = WindowKeySchema.extractWindow(binaryKey, windowSize);
        return new Windowed<Object>(key, window);
    }

    private static Window extractWindow(byte[] binaryKey, long windowSize) {
        ByteBuffer buffer = ByteBuffer.wrap(binaryKey);
        long start = buffer.getLong(binaryKey.length - 8);
        return WindowKeySchema.timeWindowForSize(start, windowSize);
    }

    public static Bytes toStoreKeyBinary(Bytes key, long timestamp, int seqnum) {
        byte[] serializedKey = key.get();
        return WindowKeySchema.toStoreKeyBinary(serializedKey, timestamp, seqnum);
    }

    public static <K> Bytes toStoreKeyBinary(K key, long timestamp, int seqnum, StateSerdes<K, ?> serdes) {
        byte[] serializedKey = serdes.rawKey(key);
        return WindowKeySchema.toStoreKeyBinary(serializedKey, timestamp, seqnum);
    }

    public static Bytes toStoreKeyBinary(Windowed<Bytes> timeKey, int seqnum) {
        byte[] bytes = timeKey.key().get();
        return WindowKeySchema.toStoreKeyBinary(bytes, timeKey.window().start(), seqnum);
    }

    public static <K> Bytes toStoreKeyBinary(Windowed<K> timeKey, int seqnum, StateSerdes<K, ?> serdes) {
        byte[] serializedKey = serdes.rawKey(timeKey.key());
        return WindowKeySchema.toStoreKeyBinary(serializedKey, timeKey.window().start(), seqnum);
    }

    static Bytes toStoreKeyBinary(byte[] serializedKey, long timestamp, int seqnum) {
        ByteBuffer buf = ByteBuffer.allocate(serializedKey.length + 8 + 4);
        buf.put(serializedKey);
        buf.putLong(timestamp);
        buf.putInt(seqnum);
        return Bytes.wrap((byte[])buf.array());
    }

    static byte[] extractStoreKeyBytes(byte[] binaryKey) {
        byte[] bytes = new byte[binaryKey.length - 8 - 4];
        System.arraycopy(binaryKey, 0, bytes, 0, bytes.length);
        return bytes;
    }

    static <K> K extractStoreKey(byte[] binaryKey, StateSerdes<K, ?> serdes) {
        byte[] bytes = new byte[binaryKey.length - 8 - 4];
        System.arraycopy(binaryKey, 0, bytes, 0, bytes.length);
        return serdes.keyFrom(bytes);
    }

    static long extractStoreTimestamp(byte[] binaryKey) {
        return ByteBuffer.wrap(binaryKey).getLong(binaryKey.length - 8 - 4);
    }

    static int extractStoreSequence(byte[] binaryKey) {
        return ByteBuffer.wrap(binaryKey).getInt(binaryKey.length - 4);
    }

    public static <K> Windowed<K> fromStoreKey(byte[] binaryKey, long windowSize, Deserializer<K> deserializer, String topic) {
        Object key = deserializer.deserialize(topic, WindowKeySchema.extractStoreKeyBytes(binaryKey));
        Window window = WindowKeySchema.extractStoreWindow(binaryKey, windowSize);
        return new Windowed<Object>(key, window);
    }

    public static <K> Windowed<K> fromStoreKey(Windowed<Bytes> windowedKey, Deserializer<K> deserializer, String topic) {
        Object key = deserializer.deserialize(topic, windowedKey.key().get());
        return new Windowed<Object>(key, windowedKey.window());
    }

    public static Windowed<Bytes> fromStoreBytesKey(byte[] binaryKey, long windowSize) {
        Bytes key = Bytes.wrap((byte[])WindowKeySchema.extractStoreKeyBytes(binaryKey));
        Window window = WindowKeySchema.extractStoreWindow(binaryKey, windowSize);
        return new Windowed<Bytes>(key, window);
    }

    static Window extractStoreWindow(byte[] binaryKey, long windowSize) {
        ByteBuffer buffer = ByteBuffer.wrap(binaryKey);
        long start = buffer.getLong(binaryKey.length - 8 - 4);
        return WindowKeySchema.timeWindowForSize(start, windowSize);
    }
}

