/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.internals.TimestampedBytesStore;

public abstract class WrappedStateStore<S extends StateStore>
implements StateStore {
    private final S wrapped;

    public static boolean isTimestamped(StateStore stateStore) {
        if (stateStore instanceof TimestampedBytesStore) {
            return true;
        }
        if (stateStore instanceof WrappedStateStore) {
            return WrappedStateStore.isTimestamped(((WrappedStateStore)stateStore).wrapped());
        }
        return false;
    }

    public WrappedStateStore(S wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.wrapped.init(context, root);
    }

    @Override
    public String name() {
        return this.wrapped.name();
    }

    @Override
    public boolean persistent() {
        return this.wrapped.persistent();
    }

    @Override
    public boolean isOpen() {
        return this.wrapped.isOpen();
    }

    void validateStoreOpen() {
        if (!this.wrapped.isOpen()) {
            throw new InvalidStateStoreException("Store " + this.wrapped.name() + " is currently closed.");
        }
    }

    @Override
    public void flush() {
        this.wrapped.flush();
    }

    @Override
    public void close() {
        this.wrapped.close();
    }

    public S wrapped() {
        return this.wrapped;
    }
}

