/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.internals;

import org.apache.kafka.streams.StreamsConfig;

public class StreamsConfigUtils {
    public static ProcessingMode processingMode(StreamsConfig config) {
        if ("exactly_once".equals(config.getString("processing.guarantee"))) {
            return ProcessingMode.EXACTLY_ONCE_ALPHA;
        }
        if ("exactly_once_beta".equals(config.getString("processing.guarantee"))) {
            return ProcessingMode.EXACTLY_ONCE_V2;
        }
        if ("exactly_once_v2".equals(config.getString("processing.guarantee"))) {
            return ProcessingMode.EXACTLY_ONCE_V2;
        }
        return ProcessingMode.AT_LEAST_ONCE;
    }

    public static String processingModeString(ProcessingMode processingMode) {
        if (processingMode == ProcessingMode.EXACTLY_ONCE_V2) {
            return "exactly_once_v2";
        }
        if (processingMode == ProcessingMode.EXACTLY_ONCE_ALPHA) {
            return "exactly_once";
        }
        return "at_least_once";
    }

    public static boolean eosEnabled(StreamsConfig config) {
        return StreamsConfigUtils.eosEnabled(StreamsConfigUtils.processingMode(config));
    }

    public static boolean eosEnabled(ProcessingMode processingMode) {
        return processingMode == ProcessingMode.EXACTLY_ONCE_ALPHA || processingMode == ProcessingMode.EXACTLY_ONCE_V2;
    }

    public static enum ProcessingMode {
        AT_LEAST_ONCE("AT_LEAST_ONCE"),
        EXACTLY_ONCE_ALPHA("EXACTLY_ONCE_ALPHA"),
        EXACTLY_ONCE_V2("EXACTLY_ONCE_V2");

        public final String name;

        private ProcessingMode(String name) {
            this.name = name;
        }
    }
}

