/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Objects;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryConfig;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.internals.PrefixedSessionKeySchemas;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedSessionSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.StoreQueryUtils;
import org.apache.kafka.streams.state.internals.WrappedSessionStoreIterator;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public class RocksDBTimeOrderedSessionStore
extends WrappedStateStore<RocksDBTimeOrderedSessionSegmentedBytesStore, Object, Object>
implements SessionStore<Bytes, byte[]> {
    private StateStoreContext stateStoreContext;

    RocksDBTimeOrderedSessionStore(RocksDBTimeOrderedSessionSegmentedBytesStore store) {
        super(store);
        Objects.requireNonNull(store, "store is null");
    }

    @Override
    public void init(StateStoreContext context, StateStore root) {
        ((RocksDBTimeOrderedSessionSegmentedBytesStore)this.wrapped()).init(context, root);
        this.stateStoreContext = context;
    }

    @Override
    public <R> QueryResult<R> query(Query<R> query, PositionBound positionBound, QueryConfig config) {
        return StoreQueryUtils.handleBasicQueries(query, positionBound, config, this, this.getPosition(), this.stateStoreContext);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> findSessions(long earliestSessionEndTime, long latestSessionEndTime) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((RocksDBTimeOrderedSessionSegmentedBytesStore)this.wrapped()).fetchSessions(earliestSessionEndTime, latestSessionEndTime);
        return new WrappedSessionStoreIterator(bytesIterator, PrefixedSessionKeySchemas.TimeFirstSessionKeySchema::from);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> findSessions(Bytes key, long earliestSessionEndTime, long latestSessionStartTime) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((RocksDBTimeOrderedSessionSegmentedBytesStore)this.wrapped()).fetch(key, earliestSessionEndTime, latestSessionStartTime);
        return new WrappedSessionStoreIterator(bytesIterator, PrefixedSessionKeySchemas.TimeFirstSessionKeySchema::from);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFindSessions(Bytes key, long earliestSessionEndTime, long latestSessionStartTime) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((RocksDBTimeOrderedSessionSegmentedBytesStore)this.wrapped()).backwardFetch(key, earliestSessionEndTime, latestSessionStartTime);
        return new WrappedSessionStoreIterator(bytesIterator, PrefixedSessionKeySchemas.TimeFirstSessionKeySchema::from);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> findSessions(Bytes keyFrom, Bytes keyTo, long earliestSessionEndTime, long latestSessionStartTime) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((RocksDBTimeOrderedSessionSegmentedBytesStore)this.wrapped()).fetch(keyFrom, keyTo, earliestSessionEndTime, latestSessionStartTime);
        return new WrappedSessionStoreIterator(bytesIterator, PrefixedSessionKeySchemas.TimeFirstSessionKeySchema::from);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFindSessions(Bytes keyFrom, Bytes keyTo, long earliestSessionEndTime, long latestSessionStartTime) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((RocksDBTimeOrderedSessionSegmentedBytesStore)this.wrapped()).backwardFetch(keyFrom, keyTo, earliestSessionEndTime, latestSessionStartTime);
        return new WrappedSessionStoreIterator(bytesIterator, PrefixedSessionKeySchemas.TimeFirstSessionKeySchema::from);
    }

    @Override
    public byte[] fetchSession(Bytes key, long earliestSessionEndTime, long latestSessionStartTime) {
        return ((RocksDBTimeOrderedSessionSegmentedBytesStore)this.wrapped()).fetchSession(key, earliestSessionEndTime, latestSessionStartTime);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes key) {
        return this.findSessions(key, 0L, Long.MAX_VALUE);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetch(Bytes key) {
        return this.backwardFindSessions(key, 0L, Long.MAX_VALUE);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes keyFrom, Bytes keyTo) {
        return this.findSessions(keyFrom, keyTo, 0L, Long.MAX_VALUE);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetch(Bytes keyFrom, Bytes keyTo) {
        return this.backwardFindSessions(keyFrom, keyTo, 0L, Long.MAX_VALUE);
    }

    @Override
    public void remove(Windowed<Bytes> sessionKey) {
        ((RocksDBTimeOrderedSessionSegmentedBytesStore)this.wrapped()).remove(sessionKey);
    }

    @Override
    public void put(Windowed<Bytes> sessionKey, byte[] aggregate) {
        ((RocksDBTimeOrderedSessionSegmentedBytesStore)this.wrapped()).put(sessionKey, aggregate);
    }
}

