/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.metrics;

import java.util.Map;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.StreamThreadTotalBlockedTime;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;

public class ThreadMetrics {
    private static final String COMMIT = "commit";
    private static final String POLL = "poll";
    private static final String PROCESS = "process";
    private static final String PUNCTUATE = "punctuate";
    private static final String CREATE_TASK = "task-created";
    private static final String CLOSE_TASK = "task-closed";
    private static final String BLOCKED_TIME = "blocked-time-ns-total";
    private static final String THREAD_START_TIME = "thread-start-time";
    private static final String COMMIT_DESCRIPTION = "calls to commit";
    private static final String COMMIT_TOTAL_DESCRIPTION = "The total number of calls to commit";
    private static final String COMMIT_RATE_DESCRIPTION = "The average per-second number of calls to commit";
    private static final String COMMIT_AVG_LATENCY_DESCRIPTION = "The average commit latency";
    private static final String COMMIT_MAX_LATENCY_DESCRIPTION = "The maximum commit latency";
    private static final String CREATE_TASK_DESCRIPTION = "newly created tasks";
    private static final String CREATE_TASK_TOTAL_DESCRIPTION = "The total number of newly created tasks";
    private static final String CREATE_TASK_RATE_DESCRIPTION = "The average per-second number of newly created tasks";
    private static final String CLOSE_TASK_DESCRIPTION = "closed tasks";
    private static final String CLOSE_TASK_TOTAL_DESCRIPTION = "The total number of closed tasks";
    private static final String CLOSE_TASK_RATE_DESCRIPTION = "The average per-second number of closed tasks";
    private static final String POLL_DESCRIPTION = "calls to poll";
    private static final String POLL_TOTAL_DESCRIPTION = "The total number of calls to poll";
    private static final String POLL_RATE_DESCRIPTION = "The average per-second number of calls to poll";
    private static final String POLL_AVG_LATENCY_DESCRIPTION = "The average poll latency";
    private static final String POLL_MAX_LATENCY_DESCRIPTION = "The maximum poll latency";
    private static final String POLL_AVG_RECORDS_DESCRIPTION = "The average number of records polled from consumer within an iteration";
    private static final String POLL_MAX_RECORDS_DESCRIPTION = "The maximum number of records polled from consumer within an iteration";
    private static final String PROCESS_DESCRIPTION = "calls to process";
    private static final String PROCESS_TOTAL_DESCRIPTION = "The total number of calls to process";
    private static final String PROCESS_RATE_DESCRIPTION = "The average per-second number of calls to process";
    private static final String PROCESS_AVG_LATENCY_DESCRIPTION = "The average process latency";
    private static final String PROCESS_MAX_LATENCY_DESCRIPTION = "The maximum process latency";
    private static final String PROCESS_AVG_RECORDS_DESCRIPTION = "The average number of records processed within an iteration";
    private static final String PROCESS_MAX_RECORDS_DESCRIPTION = "The maximum number of records processed within an iteration";
    private static final String PUNCTUATE_DESCRIPTION = "calls to punctuate";
    private static final String PUNCTUATE_TOTAL_DESCRIPTION = "The total number of calls to punctuate";
    private static final String PUNCTUATE_RATE_DESCRIPTION = "The average per-second number of calls to punctuate";
    private static final String PUNCTUATE_AVG_LATENCY_DESCRIPTION = "The average punctuate latency";
    private static final String PUNCTUATE_MAX_LATENCY_DESCRIPTION = "The maximum punctuate latency";
    private static final String COMMIT_OVER_TASKS_DESCRIPTION = "calls to commit over all tasks assigned to one stream thread";
    private static final String COMMIT_OVER_TASKS_TOTAL_DESCRIPTION = "The total number of calls to commit over all tasks assigned to one stream thread";
    private static final String COMMIT_OVER_TASKS_RATE_DESCRIPTION = "The average per-second number of calls to commit over all tasks assigned to one stream thread";
    private static final String PROCESS_RATIO_DESCRIPTION = "The fraction of time the thread spent on processing active tasks";
    private static final String PUNCTUATE_RATIO_DESCRIPTION = "The fraction of time the thread spent on punctuating active tasks";
    private static final String POLL_RATIO_DESCRIPTION = "The fraction of time the thread spent on polling records from consumer";
    private static final String COMMIT_RATIO_DESCRIPTION = "The fraction of time the thread spent on committing all tasks";
    private static final String BLOCKED_TIME_DESCRIPTION = "The total time the thread spent blocked on kafka in nanoseconds";
    private static final String THREAD_START_TIME_DESCRIPTION = "The time that the thread was started";

    private ThreadMetrics() {
    }

    public static Sensor createTaskSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        return ThreadMetrics.invocationRateAndCountSensor(threadId, CREATE_TASK, CREATE_TASK_RATE_DESCRIPTION, CREATE_TASK_TOTAL_DESCRIPTION, Sensor.RecordingLevel.INFO, streamsMetrics);
    }

    public static Sensor closeTaskSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        return ThreadMetrics.invocationRateAndCountSensor(threadId, CLOSE_TASK, CLOSE_TASK_RATE_DESCRIPTION, CLOSE_TASK_TOTAL_DESCRIPTION, Sensor.RecordingLevel.INFO, streamsMetrics);
    }

    public static Sensor commitSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        return ThreadMetrics.invocationRateAndCountAndAvgAndMaxLatencySensor(threadId, COMMIT, COMMIT_RATE_DESCRIPTION, COMMIT_TOTAL_DESCRIPTION, COMMIT_AVG_LATENCY_DESCRIPTION, COMMIT_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.INFO, streamsMetrics);
    }

    public static Sensor pollSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        return ThreadMetrics.invocationRateAndCountAndAvgAndMaxLatencySensor(threadId, POLL, POLL_RATE_DESCRIPTION, POLL_TOTAL_DESCRIPTION, POLL_AVG_LATENCY_DESCRIPTION, POLL_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.INFO, streamsMetrics);
    }

    public static Sensor processLatencySensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        Sensor sensor = streamsMetrics.threadLevelSensor(threadId, "process-latency", Sensor.RecordingLevel.INFO, new Sensor[0]);
        Map<String, String> tagMap = streamsMetrics.threadLevelTagMap(threadId);
        StreamsMetricsImpl.addAvgAndMaxToSensor(sensor, "stream-thread-metrics", tagMap, "process-latency", PROCESS_AVG_LATENCY_DESCRIPTION, PROCESS_MAX_LATENCY_DESCRIPTION);
        return sensor;
    }

    public static Sensor pollRecordsSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        Sensor sensor = streamsMetrics.threadLevelSensor(threadId, "poll-records", Sensor.RecordingLevel.INFO, new Sensor[0]);
        Map<String, String> tagMap = streamsMetrics.threadLevelTagMap(threadId);
        StreamsMetricsImpl.addAvgAndMaxToSensor(sensor, "stream-thread-metrics", tagMap, "poll-records", POLL_AVG_RECORDS_DESCRIPTION, POLL_MAX_RECORDS_DESCRIPTION);
        return sensor;
    }

    public static Sensor processRecordsSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        Sensor sensor = streamsMetrics.threadLevelSensor(threadId, "process-records", Sensor.RecordingLevel.INFO, new Sensor[0]);
        Map<String, String> tagMap = streamsMetrics.threadLevelTagMap(threadId);
        StreamsMetricsImpl.addAvgAndMaxToSensor(sensor, "stream-thread-metrics", tagMap, "process-records", PROCESS_AVG_RECORDS_DESCRIPTION, PROCESS_MAX_RECORDS_DESCRIPTION);
        return sensor;
    }

    public static Sensor processRateSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        Sensor sensor = streamsMetrics.threadLevelSensor(threadId, "process-rate", Sensor.RecordingLevel.INFO, new Sensor[0]);
        Map<String, String> tagMap = streamsMetrics.threadLevelTagMap(threadId);
        StreamsMetricsImpl.addRateOfSumAndSumMetricsToSensor(sensor, "stream-thread-metrics", tagMap, PROCESS, PROCESS_RATE_DESCRIPTION, PROCESS_TOTAL_DESCRIPTION);
        return sensor;
    }

    public static Sensor punctuateSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        return ThreadMetrics.invocationRateAndCountAndAvgAndMaxLatencySensor(threadId, PUNCTUATE, PUNCTUATE_RATE_DESCRIPTION, PUNCTUATE_TOTAL_DESCRIPTION, PUNCTUATE_AVG_LATENCY_DESCRIPTION, PUNCTUATE_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.INFO, streamsMetrics);
    }

    public static Sensor commitOverTasksSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        Sensor commitOverTasksSensor = streamsMetrics.threadLevelSensor(threadId, COMMIT, Sensor.RecordingLevel.DEBUG, new Sensor[0]);
        Map<String, String> tagMap = streamsMetrics.taskLevelTagMap(threadId, "all");
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(commitOverTasksSensor, "stream-task-metrics", tagMap, COMMIT, COMMIT_OVER_TASKS_RATE_DESCRIPTION, COMMIT_OVER_TASKS_TOTAL_DESCRIPTION);
        return commitOverTasksSensor;
    }

    public static Sensor processRatioSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        Sensor sensor = streamsMetrics.threadLevelSensor(threadId, "process-ratio", Sensor.RecordingLevel.INFO, new Sensor[0]);
        Map<String, String> tagMap = streamsMetrics.threadLevelTagMap(threadId);
        StreamsMetricsImpl.addValueMetricToSensor(sensor, "stream-thread-metrics", tagMap, "process-ratio", PROCESS_RATIO_DESCRIPTION);
        return sensor;
    }

    public static Sensor punctuateRatioSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        Sensor sensor = streamsMetrics.threadLevelSensor(threadId, "punctuate-ratio", Sensor.RecordingLevel.INFO, new Sensor[0]);
        Map<String, String> tagMap = streamsMetrics.threadLevelTagMap(threadId);
        StreamsMetricsImpl.addValueMetricToSensor(sensor, "stream-thread-metrics", tagMap, "punctuate-ratio", PUNCTUATE_RATIO_DESCRIPTION);
        return sensor;
    }

    public static Sensor pollRatioSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        Sensor sensor = streamsMetrics.threadLevelSensor(threadId, "poll-ratio", Sensor.RecordingLevel.INFO, new Sensor[0]);
        Map<String, String> tagMap = streamsMetrics.threadLevelTagMap(threadId);
        StreamsMetricsImpl.addValueMetricToSensor(sensor, "stream-thread-metrics", tagMap, "poll-ratio", POLL_RATIO_DESCRIPTION);
        return sensor;
    }

    public static Sensor commitRatioSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        Sensor sensor = streamsMetrics.threadLevelSensor(threadId, "commit-ratio", Sensor.RecordingLevel.INFO, new Sensor[0]);
        Map<String, String> tagMap = streamsMetrics.threadLevelTagMap(threadId);
        StreamsMetricsImpl.addValueMetricToSensor(sensor, "stream-thread-metrics", tagMap, "commit-ratio", COMMIT_RATIO_DESCRIPTION);
        return sensor;
    }

    public static void addThreadStartTimeMetric(String threadId, StreamsMetricsImpl streamsMetrics, long startTime) {
        streamsMetrics.addThreadLevelImmutableMetric(THREAD_START_TIME, THREAD_START_TIME_DESCRIPTION, threadId, startTime);
    }

    public static void addThreadBlockedTimeMetric(String threadId, StreamThreadTotalBlockedTime blockedTime, StreamsMetricsImpl streamsMetrics) {
        streamsMetrics.addThreadLevelMutableMetric(BLOCKED_TIME, BLOCKED_TIME_DESCRIPTION, threadId, (config, now) -> blockedTime.compute());
    }

    private static Sensor invocationRateAndCountSensor(String threadId, String metricName, String descriptionOfRate, String descriptionOfCount, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics) {
        Sensor sensor = streamsMetrics.threadLevelSensor(threadId, metricName, recordingLevel, new Sensor[0]);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(sensor, "stream-thread-metrics", streamsMetrics.threadLevelTagMap(threadId), metricName, descriptionOfRate, descriptionOfCount);
        return sensor;
    }

    private static Sensor invocationRateAndCountAndAvgAndMaxLatencySensor(String threadId, String metricName, String descriptionOfRate, String descriptionOfCount, String descriptionOfAvg, String descriptionOfMax, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics) {
        Sensor sensor = streamsMetrics.threadLevelSensor(threadId, metricName, recordingLevel, new Sensor[0]);
        Map<String, String> tagMap = streamsMetrics.threadLevelTagMap(threadId);
        StreamsMetricsImpl.addAvgAndMaxToSensor(sensor, "stream-thread-metrics", tagMap, metricName + "-latency", descriptionOfAvg, descriptionOfMax);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(sensor, "stream-thread-metrics", tagMap, metricName, descriptionOfRate, descriptionOfCount);
        return sensor;
    }
}

