/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.WrappingNullableUtils;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextUtils;
import org.apache.kafka.streams.processor.internals.SerdeGetter;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.query.FailureReason;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryConfig;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.query.WindowKeyQuery;
import org.apache.kafka.streams.query.WindowRangeQuery;
import org.apache.kafka.streams.query.internals.InternalQueryResultUtil;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.MeteredWindowStoreIterator;
import org.apache.kafka.streams.state.internals.MeteredWindowedKeyValueIterator;
import org.apache.kafka.streams.state.internals.StoreQueryUtils;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.apache.kafka.streams.state.internals.metrics.StateStoreMetrics;

public class MeteredWindowStore<K, V>
extends WrappedStateStore<WindowStore<Bytes, byte[]>, Windowed<K>, V>
implements WindowStore<K, V> {
    private final long windowSizeMs;
    private final String metricsScope;
    private final Time time;
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;
    private StateSerdes<K, V> serdes;
    private StreamsMetricsImpl streamsMetrics;
    private Sensor putSensor;
    private Sensor fetchSensor;
    private Sensor flushSensor;
    private Sensor e2eLatencySensor;
    private InternalProcessorContext<?, ?> context;
    private TaskId taskId;
    private final Map<Class, StoreQueryUtils.QueryHandler> queryHandlers = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry(WindowRangeQuery.class, (query, positionBound, config, store) -> this.runRangeQuery(query, positionBound, config)), Utils.mkEntry(WindowKeyQuery.class, (query, positionBound, config, store) -> this.runKeyQuery(query, positionBound, config))});

    MeteredWindowStore(WindowStore<Bytes, byte[]> inner, long windowSizeMs, String metricsScope, Time time, Serde<K> keySerde, Serde<V> valueSerde) {
        super(inner);
        this.windowSizeMs = windowSizeMs;
        this.metricsScope = metricsScope;
        this.time = time;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
    }

    @Override
    @Deprecated
    public void init(ProcessorContext context, StateStore root) {
        this.context = context instanceof InternalProcessorContext ? (InternalProcessorContext)context : null;
        this.taskId = context.taskId();
        this.initStoreSerde(context);
        this.streamsMetrics = (StreamsMetricsImpl)context.metrics();
        this.registerMetrics();
        Sensor restoreSensor = StateStoreMetrics.restoreSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        StreamsMetricsImpl.maybeMeasureLatency(() -> super.init(context, root), this.time, restoreSensor);
    }

    @Override
    public void init(StateStoreContext context, StateStore root) {
        this.context = context instanceof InternalProcessorContext ? (InternalProcessorContext)context : null;
        this.taskId = context.taskId();
        this.initStoreSerde(context);
        this.streamsMetrics = (StreamsMetricsImpl)context.metrics();
        this.registerMetrics();
        Sensor restoreSensor = StateStoreMetrics.restoreSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        StreamsMetricsImpl.maybeMeasureLatency(() -> super.init(context, root), this.time, restoreSensor);
    }

    protected Serde<V> prepareValueSerde(Serde<V> valueSerde, SerdeGetter getter) {
        return WrappingNullableUtils.prepareValueSerde(valueSerde, getter);
    }

    private void registerMetrics() {
        this.putSensor = StateStoreMetrics.putSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.fetchSensor = StateStoreMetrics.fetchSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.flushSensor = StateStoreMetrics.flushSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.e2eLatencySensor = StateStoreMetrics.e2ELatencySensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
    }

    @Deprecated
    private void initStoreSerde(ProcessorContext context) {
        String storeName = this.name();
        String changelogTopic = ProcessorContextUtils.changelogFor(context, storeName, Boolean.FALSE);
        this.serdes = new StateSerdes<K, V>(changelogTopic, WrappingNullableUtils.prepareKeySerde(this.keySerde, new SerdeGetter(context)), this.prepareValueSerde(this.valueSerde, new SerdeGetter(context)));
    }

    private void initStoreSerde(StateStoreContext context) {
        String storeName = this.name();
        String changelogTopic = ProcessorContextUtils.changelogFor(context, storeName, Boolean.FALSE);
        this.serdes = new StateSerdes<K, V>(changelogTopic, WrappingNullableUtils.prepareKeySerde(this.keySerde, new SerdeGetter(context)), this.prepareValueSerde(this.valueSerde, new SerdeGetter(context)));
    }

    @Override
    public boolean setFlushListener(CacheFlushListener<Windowed<K>, V> listener, boolean sendOldValues) {
        WindowStore wrapped = (WindowStore)this.wrapped();
        if (wrapped instanceof CachedStateStore) {
            return ((CachedStateStore)((Object)wrapped)).setFlushListener((Record<K, Change<V>> record) -> listener.apply(record.withKey(WindowKeySchema.fromStoreKey((byte[])record.key(), this.windowSizeMs, this.serdes.keyDeserializer(), this.serdes.topic())).withValue(new Change<Object>((((Change)record.value()).newValue != null ? (Object)this.serdes.valueFrom((byte[])((Change)record.value()).newValue) : null), (((Change)record.value()).oldValue != null ? (Object)this.serdes.valueFrom((byte[])((Change)record.value()).oldValue) : null)))), sendOldValues);
        }
        return false;
    }

    @Override
    public void put(K key, V value, long windowStartTimestamp) {
        Objects.requireNonNull(key, "key cannot be null");
        try {
            StreamsMetricsImpl.maybeMeasureLatency(() -> ((WindowStore)this.wrapped()).put(this.keyBytes(key), this.serdes.rawValue(value), windowStartTimestamp), this.time, this.putSensor);
            this.maybeRecordE2ELatency();
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key, value);
            throw new ProcessorStateException(message, (Throwable)((Object)e));
        }
    }

    @Override
    public V fetch(K key, long timestamp) {
        Objects.requireNonNull(key, "key cannot be null");
        return (V)StreamsMetricsImpl.maybeMeasureLatency(() -> {
            byte[] result = (byte[])((WindowStore)this.wrapped()).fetch(this.keyBytes(key), timestamp);
            if (result == null) {
                return null;
            }
            return this.serdes.valueFrom(result);
        }, this.time, this.fetchSensor);
    }

    @Override
    public WindowStoreIterator<V> fetch(K key, long timeFrom, long timeTo) {
        Objects.requireNonNull(key, "key cannot be null");
        return new MeteredWindowStoreIterator<Object>(((WindowStore)this.wrapped()).fetch(this.keyBytes(key), timeFrom, timeTo), this.fetchSensor, this.streamsMetrics, this.serdes::valueFrom, this.time);
    }

    @Override
    public WindowStoreIterator<V> backwardFetch(K key, long timeFrom, long timeTo) {
        Objects.requireNonNull(key, "key cannot be null");
        return new MeteredWindowStoreIterator<Object>(((WindowStore)this.wrapped()).backwardFetch(this.keyBytes(key), timeFrom, timeTo), this.fetchSensor, this.streamsMetrics, this.serdes::valueFrom, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(K keyFrom, K keyTo, long timeFrom, long timeTo) {
        return new MeteredWindowedKeyValueIterator<Object, Object>(((WindowStore)this.wrapped()).fetch(this.keyBytes(keyFrom), this.keyBytes(keyTo), timeFrom, timeTo), this.fetchSensor, this.streamsMetrics, this.serdes::keyFrom, this.serdes::valueFrom, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> backwardFetch(K keyFrom, K keyTo, long timeFrom, long timeTo) {
        return new MeteredWindowedKeyValueIterator<Object, Object>(((WindowStore)this.wrapped()).backwardFetch(this.keyBytes(keyFrom), this.keyBytes(keyTo), timeFrom, timeTo), this.fetchSensor, this.streamsMetrics, this.serdes::keyFrom, this.serdes::valueFrom, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetchAll(long timeFrom, long timeTo) {
        return new MeteredWindowedKeyValueIterator<Object, Object>(((WindowStore)this.wrapped()).fetchAll(timeFrom, timeTo), this.fetchSensor, this.streamsMetrics, this.serdes::keyFrom, this.serdes::valueFrom, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> backwardFetchAll(long timeFrom, long timeTo) {
        return new MeteredWindowedKeyValueIterator<Object, Object>(((WindowStore)this.wrapped()).backwardFetchAll(timeFrom, timeTo), this.fetchSensor, this.streamsMetrics, this.serdes::keyFrom, this.serdes::valueFrom, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> all() {
        return new MeteredWindowedKeyValueIterator<Object, Object>(((WindowStore)this.wrapped()).all(), this.fetchSensor, this.streamsMetrics, this.serdes::keyFrom, this.serdes::valueFrom, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> backwardAll() {
        return new MeteredWindowedKeyValueIterator<Object, Object>(((WindowStore)this.wrapped()).backwardAll(), this.fetchSensor, this.streamsMetrics, this.serdes::keyFrom, this.serdes::valueFrom, this.time);
    }

    @Override
    public void flush() {
        StreamsMetricsImpl.maybeMeasureLatency(() -> super.flush(), this.time, this.flushSensor);
    }

    @Override
    public void close() {
        try {
            ((WindowStore)this.wrapped()).close();
        }
        finally {
            this.streamsMetrics.removeAllStoreLevelSensorsAndMetrics(this.taskId.toString(), this.name());
        }
    }

    @Override
    public <R> QueryResult<R> query(Query<R> query, PositionBound positionBound, QueryConfig config) {
        QueryResult<Object> result;
        long start = this.time.nanoseconds();
        StoreQueryUtils.QueryHandler handler = this.queryHandlers.get(query.getClass());
        if (handler == null) {
            result = ((WindowStore)this.wrapped()).query(query, positionBound, config);
            if (config.isCollectExecutionInfo()) {
                result.addExecutionInfo("Handled in " + this.getClass() + " in " + (this.time.nanoseconds() - start) + "ns");
            }
        } else {
            result = handler.apply(query, positionBound, config, this);
            if (config.isCollectExecutionInfo()) {
                result.addExecutionInfo("Handled in " + this.getClass() + " with serdes " + this.serdes + " in " + (this.time.nanoseconds() - start) + "ns");
            }
        }
        return result;
    }

    private <R> QueryResult<R> runRangeQuery(Query<R> query, PositionBound positionBound, QueryConfig config) {
        QueryResult<Object> result;
        WindowRangeQuery typedQuery = (WindowRangeQuery)query;
        if (typedQuery.getTimeFrom().isPresent() && typedQuery.getTimeTo().isPresent()) {
            WindowRangeQuery rawKeyQuery = WindowRangeQuery.withWindowStartRange(typedQuery.getTimeFrom().get(), typedQuery.getTimeTo().get());
            QueryResult rawResult = ((WindowStore)this.wrapped()).query(rawKeyQuery, positionBound, config);
            if (rawResult.isSuccess()) {
                MeteredWindowedKeyValueIterator<Object, V> typedResult = new MeteredWindowedKeyValueIterator<Object, V>((KeyValueIterator)rawResult.getResult(), this.fetchSensor, this.streamsMetrics, this.serdes::keyFrom, StoreQueryUtils.getDeserializeValue(this.serdes, this.wrapped()), this.time);
                QueryResult<MeteredWindowedKeyValueIterator<Object, V>> typedQueryResult = InternalQueryResultUtil.copyAndSubstituteDeserializedResult(rawResult, typedResult);
                result = typedQueryResult;
            } else {
                result = rawResult;
            }
        } else {
            result = QueryResult.forFailure(FailureReason.UNKNOWN_QUERY_TYPE, "This store (" + this.getClass() + ") doesn't know how to execute the given query (" + query + ") because WindowStores only supports WindowRangeQuery.withWindowStartRange. Contact the store maintainer if you need support for a new query type.");
        }
        return result;
    }

    private <R> QueryResult<R> runKeyQuery(Query<R> query, PositionBound positionBound, QueryConfig config) {
        QueryResult<Object> queryResult;
        WindowKeyQuery typedQuery = (WindowKeyQuery)query;
        if (typedQuery.getTimeFrom().isPresent() && typedQuery.getTimeTo().isPresent()) {
            WindowKeyQuery rawKeyQuery = WindowKeyQuery.withKeyAndWindowStartRange(this.keyBytes(typedQuery.getKey()), typedQuery.getTimeFrom().get(), typedQuery.getTimeTo().get());
            QueryResult rawResult = ((WindowStore)this.wrapped()).query(rawKeyQuery, positionBound, config);
            if (rawResult.isSuccess()) {
                MeteredWindowStoreIterator<V> typedResult = new MeteredWindowStoreIterator<V>((WindowStoreIterator)rawResult.getResult(), this.fetchSensor, this.streamsMetrics, StoreQueryUtils.getDeserializeValue(this.serdes, this.wrapped()), this.time);
                QueryResult<MeteredWindowStoreIterator<V>> typedQueryResult = InternalQueryResultUtil.copyAndSubstituteDeserializedResult(rawResult, typedResult);
                queryResult = typedQueryResult;
            } else {
                queryResult = rawResult;
            }
        } else {
            queryResult = QueryResult.forFailure(FailureReason.UNKNOWN_QUERY_TYPE, "This store (" + this.getClass() + ") doesn't know how to execute the given query (" + query + ") because it only supports closed-range queries. Contact the store maintainer if you need support for a new query type.");
        }
        return queryResult;
    }

    private Bytes keyBytes(K key) {
        return Bytes.wrap((byte[])this.serdes.rawKey(key));
    }

    protected V outerValue(byte[] value) {
        return value != null ? (V)this.serdes.valueFrom(value) : null;
    }

    private void maybeRecordE2ELatency() {
        if (this.e2eLatencySensor.shouldRecord() && this.context != null) {
            long currentTime = this.time.milliseconds();
            long e2eLatency = currentTime - this.context.timestamp();
            this.e2eLatencySensor.record((double)e2eLatency, currentTime);
        }
    }
}

