/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.KeyValueIteratorFacade;

public class ReadOnlyKeyValueStoreFacade<K, V>
implements ReadOnlyKeyValueStore<K, V> {
    protected final TimestampedKeyValueStore<K, V> inner;

    protected ReadOnlyKeyValueStoreFacade(TimestampedKeyValueStore<K, V> store) {
        this.inner = store;
    }

    @Override
    public V get(K key) {
        return ValueAndTimestamp.getValueOrNull((ValueAndTimestamp)this.inner.get(key));
    }

    @Override
    public KeyValueIterator<K, V> range(K from, K to) {
        return new KeyValueIteratorFacade(this.inner.range(from, to));
    }

    @Override
    public KeyValueIterator<K, V> all() {
        return new KeyValueIteratorFacade(this.inner.all());
    }

    @Override
    public long approximateNumEntries() {
        return this.inner.approximateNumEntries();
    }
}

