/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.streams.errors.TaskAssignmentException;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.state.HostInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignmentInfo {
    private static final Logger log = LoggerFactory.getLogger(AssignmentInfo.class);
    private final int usedVersion;
    private final int commonlySupportedVersion;
    private int errCode;
    private List<TaskId> activeTasks;
    private Map<TaskId, Set<TopicPartition>> standbyTasks;
    private Map<HostInfo, Set<TopicPartition>> partitionsByHost;

    public AssignmentInfo(int version, int commonlySupportedVersion) {
        this(version, commonlySupportedVersion, Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), 0);
    }

    public AssignmentInfo(List<TaskId> activeTasks, Map<TaskId, Set<TopicPartition>> standbyTasks, Map<HostInfo, Set<TopicPartition>> partitionsByHost) {
        this(5, activeTasks, standbyTasks, partitionsByHost, 0);
    }

    public AssignmentInfo(int version, List<TaskId> activeTasks, Map<TaskId, Set<TopicPartition>> standbyTasks, Map<HostInfo, Set<TopicPartition>> partitionsByHost, int errCode) {
        this(version, 5, activeTasks, standbyTasks, partitionsByHost, errCode);
    }

    public AssignmentInfo(int version, int commonlySupportedVersion, List<TaskId> activeTasks, Map<TaskId, Set<TopicPartition>> standbyTasks, Map<HostInfo, Set<TopicPartition>> partitionsByHost, int errCode) {
        this.usedVersion = version;
        this.commonlySupportedVersion = commonlySupportedVersion;
        this.activeTasks = activeTasks;
        this.standbyTasks = standbyTasks;
        this.partitionsByHost = partitionsByHost;
        this.errCode = errCode;
        if (version < 1 || version > 5) {
            throw new IllegalArgumentException("version must be between 1 and 5; was: " + version);
        }
    }

    public int version() {
        return this.usedVersion;
    }

    public int errCode() {
        return this.errCode;
    }

    public int commonlySupportedVersion() {
        return this.commonlySupportedVersion;
    }

    public List<TaskId> activeTasks() {
        return this.activeTasks;
    }

    public Map<TaskId, Set<TopicPartition>> standbyTasks() {
        return this.standbyTasks;
    }

    public Map<HostInfo, Set<TopicPartition>> partitionsByHost() {
        return this.partitionsByHost;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer encode() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(baos);){
            switch (this.usedVersion) {
                case 1: {
                    this.encodeVersionOne(out);
                    break;
                }
                case 2: {
                    this.encodeVersionTwo(out);
                    break;
                }
                case 3: {
                    this.encodeVersionThree(out);
                    break;
                }
                case 4: {
                    this.encodeVersionFour(out);
                    break;
                }
                case 5: {
                    this.encodeVersionFive(out);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown metadata version: " + this.usedVersion + "; latest commonly supported version: " + this.commonlySupportedVersion);
                }
            }
            out.flush();
            out.close();
            ByteBuffer byteBuffer = ByteBuffer.wrap(baos.toByteArray());
            return byteBuffer;
        }
        catch (IOException ex) {
            throw new TaskAssignmentException("Failed to encode AssignmentInfo", ex);
        }
    }

    private void encodeVersionOne(DataOutputStream out) throws IOException {
        out.writeInt(1);
        this.encodeActiveAndStandbyTaskAssignment(out);
    }

    private void encodeActiveAndStandbyTaskAssignment(DataOutputStream out) throws IOException {
        out.writeInt(this.activeTasks.size());
        for (TaskId taskId : this.activeTasks) {
            taskId.writeTo(out);
        }
        out.writeInt(this.standbyTasks.size());
        for (Map.Entry entry : this.standbyTasks.entrySet()) {
            TaskId id = (TaskId)entry.getKey();
            id.writeTo(out);
            Set partitions = (Set)entry.getValue();
            this.writeTopicPartitions(out, partitions);
        }
    }

    private void encodeVersionTwo(DataOutputStream out) throws IOException {
        out.writeInt(2);
        this.encodeActiveAndStandbyTaskAssignment(out);
        this.encodePartitionsByHost(out);
    }

    private void encodePartitionsByHost(DataOutputStream out) throws IOException {
        out.writeInt(this.partitionsByHost.size());
        for (Map.Entry<HostInfo, Set<TopicPartition>> entry : this.partitionsByHost.entrySet()) {
            this.writeHostInfo(out, entry.getKey());
            this.writeTopicPartitions(out, entry.getValue());
        }
    }

    private void encodePartitionsByHostAsDictionary(DataOutputStream out) throws IOException {
        int topicIndex = 0;
        HashMap<String, Integer> topicNameDict = new HashMap<String, Integer>();
        for (Map.Entry<HostInfo, Set<TopicPartition>> entry : this.partitionsByHost.entrySet()) {
            for (TopicPartition topicPartition : entry.getValue()) {
                if (topicNameDict.containsKey(topicPartition.topic())) continue;
                topicNameDict.put(topicPartition.topic(), topicIndex++);
            }
        }
        out.writeInt(topicNameDict.size());
        for (Map.Entry<HostInfo, Set<Object>> entry : topicNameDict.entrySet()) {
            out.writeInt((Integer)((Object)entry.getValue()));
            out.writeUTF((String)((Object)entry.getKey()));
        }
        out.writeInt(this.partitionsByHost.size());
        for (Map.Entry<HostInfo, Set<Object>> entry : this.partitionsByHost.entrySet()) {
            this.writeHostInfo(out, entry.getKey());
            out.writeInt(entry.getValue().size());
            for (TopicPartition topicPartition : entry.getValue()) {
                out.writeInt((Integer)topicNameDict.get(topicPartition.topic()));
                out.writeInt(topicPartition.partition());
            }
        }
    }

    private void writeHostInfo(DataOutputStream out, HostInfo hostInfo) throws IOException {
        out.writeUTF(hostInfo.host());
        out.writeInt(hostInfo.port());
    }

    private void writeTopicPartitions(DataOutputStream out, Set<TopicPartition> partitions) throws IOException {
        out.writeInt(partitions.size());
        for (TopicPartition partition : partitions) {
            out.writeUTF(partition.topic());
            out.writeInt(partition.partition());
        }
    }

    private void encodeVersionThree(DataOutputStream out) throws IOException {
        out.writeInt(3);
        out.writeInt(this.commonlySupportedVersion);
        this.encodeActiveAndStandbyTaskAssignment(out);
        this.encodePartitionsByHost(out);
    }

    private void encodeVersionFour(DataOutputStream out) throws IOException {
        out.writeInt(4);
        out.writeInt(this.commonlySupportedVersion);
        this.encodeActiveAndStandbyTaskAssignment(out);
        this.encodePartitionsByHost(out);
        out.writeInt(this.errCode);
    }

    private void encodeVersionFive(DataOutputStream out) throws IOException {
        out.writeInt(5);
        out.writeInt(this.commonlySupportedVersion);
        this.encodeActiveAndStandbyTaskAssignment(out);
        this.encodePartitionsByHostAsDictionary(out);
        out.writeInt(this.errCode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AssignmentInfo decode(ByteBuffer data) {
        data.rewind();
        try (DataInputStream in = new DataInputStream((InputStream)new ByteBufferInputStream(data));){
            AssignmentInfo assignmentInfo;
            int usedVersion = in.readInt();
            switch (usedVersion) {
                case 1: {
                    assignmentInfo = new AssignmentInfo(usedVersion, -1);
                    AssignmentInfo.decodeVersionOneData(assignmentInfo, in);
                    break;
                }
                case 2: {
                    assignmentInfo = new AssignmentInfo(usedVersion, -1);
                    AssignmentInfo.decodeVersionTwoData(assignmentInfo, in);
                    break;
                }
                case 3: {
                    int commonlySupportedVersion = in.readInt();
                    assignmentInfo = new AssignmentInfo(usedVersion, commonlySupportedVersion);
                    AssignmentInfo.decodeVersionThreeData(assignmentInfo, in);
                    break;
                }
                case 4: {
                    int commonlySupportedVersion = in.readInt();
                    assignmentInfo = new AssignmentInfo(usedVersion, commonlySupportedVersion);
                    AssignmentInfo.decodeVersionFourData(assignmentInfo, in);
                    break;
                }
                case 5: {
                    int commonlySupportedVersion = in.readInt();
                    assignmentInfo = new AssignmentInfo(usedVersion, commonlySupportedVersion);
                    AssignmentInfo.decodeVersionFiveData(assignmentInfo, in);
                    break;
                }
                default: {
                    TaskAssignmentException fatalException = new TaskAssignmentException("Unable to decode assignment data: used version: " + usedVersion + "; latest supported version: " + 5);
                    log.error(fatalException.getMessage(), (Throwable)((Object)fatalException));
                    throw fatalException;
                }
            }
            AssignmentInfo assignmentInfo2 = assignmentInfo;
            return assignmentInfo2;
        }
        catch (IOException ex) {
            throw new TaskAssignmentException("Failed to decode AssignmentInfo", ex);
        }
    }

    private static void decodeVersionOneData(AssignmentInfo assignmentInfo, DataInputStream in) throws IOException {
        AssignmentInfo.decodeActiveTasks(assignmentInfo, in);
        AssignmentInfo.decodeStandbyTasks(assignmentInfo, in);
        assignmentInfo.partitionsByHost = new HashMap<HostInfo, Set<TopicPartition>>();
    }

    private static void decodeActiveTasks(AssignmentInfo assignmentInfo, DataInputStream in) throws IOException {
        int count = in.readInt();
        assignmentInfo.activeTasks = new ArrayList<TaskId>(count);
        for (int i = 0; i < count; ++i) {
            assignmentInfo.activeTasks.add(TaskId.readFrom(in));
        }
    }

    private static void decodeStandbyTasks(AssignmentInfo assignmentInfo, DataInputStream in) throws IOException {
        int count = in.readInt();
        assignmentInfo.standbyTasks = new HashMap<TaskId, Set<TopicPartition>>(count);
        for (int i = 0; i < count; ++i) {
            TaskId id = TaskId.readFrom(in);
            assignmentInfo.standbyTasks.put(id, AssignmentInfo.readTopicPartitions(in));
        }
    }

    private static void decodeVersionTwoData(AssignmentInfo assignmentInfo, DataInputStream in) throws IOException {
        AssignmentInfo.decodeActiveTasks(assignmentInfo, in);
        AssignmentInfo.decodeStandbyTasks(assignmentInfo, in);
        AssignmentInfo.decodePartitionsByHost(assignmentInfo, in);
    }

    private static void decodePartitionsByHost(AssignmentInfo assignmentInfo, DataInputStream in) throws IOException {
        assignmentInfo.partitionsByHost = new HashMap<HostInfo, Set<TopicPartition>>();
        int numEntries = in.readInt();
        for (int i = 0; i < numEntries; ++i) {
            HostInfo hostInfo = new HostInfo(in.readUTF(), in.readInt());
            assignmentInfo.partitionsByHost.put(hostInfo, AssignmentInfo.readTopicPartitions(in));
        }
    }

    private static Set<TopicPartition> readTopicPartitions(DataInputStream in) throws IOException {
        int numPartitions = in.readInt();
        HashSet<TopicPartition> partitions = new HashSet<TopicPartition>(numPartitions);
        for (int j = 0; j < numPartitions; ++j) {
            partitions.add(new TopicPartition(in.readUTF(), in.readInt()));
        }
        return partitions;
    }

    private static void decodePartitionsByHostUsingDictionary(AssignmentInfo assignmentInfo, DataInputStream in) throws IOException {
        assignmentInfo.partitionsByHost = new HashMap<HostInfo, Set<TopicPartition>>();
        int dictSize = in.readInt();
        HashMap<Integer, String> topicIndexDict = new HashMap<Integer, String>(dictSize);
        for (int i = 0; i < dictSize; ++i) {
            topicIndexDict.put(in.readInt(), in.readUTF());
        }
        int numEntries = in.readInt();
        for (int i = 0; i < numEntries; ++i) {
            HostInfo hostInfo = new HostInfo(in.readUTF(), in.readInt());
            assignmentInfo.partitionsByHost.put(hostInfo, AssignmentInfo.readTopicPartitions(in, topicIndexDict));
        }
    }

    private static Set<TopicPartition> readTopicPartitions(DataInputStream in, Map<Integer, String> topicIndexDict) throws IOException {
        int numPartitions = in.readInt();
        HashSet<TopicPartition> partitions = new HashSet<TopicPartition>(numPartitions);
        for (int j = 0; j < numPartitions; ++j) {
            partitions.add(new TopicPartition(topicIndexDict.get(in.readInt()), in.readInt()));
        }
        return partitions;
    }

    private static void decodeVersionThreeData(AssignmentInfo assignmentInfo, DataInputStream in) throws IOException {
        AssignmentInfo.decodeActiveTasks(assignmentInfo, in);
        AssignmentInfo.decodeStandbyTasks(assignmentInfo, in);
        AssignmentInfo.decodePartitionsByHost(assignmentInfo, in);
    }

    private static void decodeVersionFourData(AssignmentInfo assignmentInfo, DataInputStream in) throws IOException {
        AssignmentInfo.decodeVersionThreeData(assignmentInfo, in);
        assignmentInfo.errCode = in.readInt();
    }

    private static void decodeVersionFiveData(AssignmentInfo assignmentInfo, DataInputStream in) throws IOException {
        AssignmentInfo.decodeActiveTasks(assignmentInfo, in);
        AssignmentInfo.decodeStandbyTasks(assignmentInfo, in);
        AssignmentInfo.decodePartitionsByHostUsingDictionary(assignmentInfo, in);
        assignmentInfo.errCode = in.readInt();
    }

    public int hashCode() {
        return this.usedVersion ^ this.commonlySupportedVersion ^ this.activeTasks.hashCode() ^ this.standbyTasks.hashCode() ^ this.partitionsByHost.hashCode() ^ this.errCode;
    }

    public boolean equals(Object o) {
        if (o instanceof AssignmentInfo) {
            AssignmentInfo other = (AssignmentInfo)o;
            return this.usedVersion == other.usedVersion && this.commonlySupportedVersion == other.commonlySupportedVersion && this.errCode == other.errCode && this.activeTasks.equals(other.activeTasks) && this.standbyTasks.equals(other.standbyTasks) && this.partitionsByHost.equals(other.partitionsByHost);
        }
        return false;
    }

    public String toString() {
        return "[version=" + this.usedVersion + ", supported version=" + this.commonlySupportedVersion + ", active tasks=" + this.activeTasks + ", standby tasks=" + this.standbyTasks + ", partitions by host=" + this.partitionsByHost + "]";
    }
}

