/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.state.StateSerdes;

class StoreChangeLogger<K, V> {
    private final String topic;
    private final int partition;
    private final ProcessorContext context;
    private final RecordCollector collector;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;

    StoreChangeLogger(String storeName, ProcessorContext context, StateSerdes<K, V> serialization) {
        this(storeName, context, context.taskId().partition, serialization);
    }

    private StoreChangeLogger(String storeName, ProcessorContext context, int partition, StateSerdes<K, V> serialization) {
        this.topic = ProcessorStateManager.storeChangelogTopic(context.applicationId(), storeName);
        this.context = context;
        this.partition = partition;
        this.collector = ((RecordCollector.Supplier)((Object)context)).recordCollector();
        this.keySerializer = serialization.keySerializer();
        this.valueSerializer = serialization.valueSerializer();
    }

    void logChange(K key, V value) {
        this.logChange(key, value, this.context.timestamp());
    }

    void logChange(K key, V value, long timestamp) {
        this.collector.send(this.topic, key, value, null, this.partition, timestamp, this.keySerializer, this.valueSerializer);
    }
}

