/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.internals.ConsumedInternal;
import org.apache.kafka.streams.kstream.internals.graph.StreamsGraphNode;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;

public class StreamSourceNode<K, V>
extends StreamsGraphNode {
    private Collection<String> topicNames;
    private Pattern topicPattern;
    private final ConsumedInternal<K, V> consumedInternal;

    public StreamSourceNode(String nodeName, Collection<String> topicNames, ConsumedInternal<K, V> consumedInternal) {
        super(nodeName);
        this.topicNames = topicNames;
        this.consumedInternal = consumedInternal;
    }

    public StreamSourceNode(String nodeName, Pattern topicPattern, ConsumedInternal<K, V> consumedInternal) {
        super(nodeName);
        this.topicPattern = topicPattern;
        this.consumedInternal = consumedInternal;
    }

    public Collection<String> getTopicNames() {
        return new ArrayList<String>(this.topicNames);
    }

    public Pattern topicPattern() {
        return this.topicPattern;
    }

    public ConsumedInternal<K, V> consumedInternal() {
        return this.consumedInternal;
    }

    public Serde<K> keySerde() {
        return this.consumedInternal.keySerde();
    }

    public Serde<V> valueSerde() {
        return this.consumedInternal.valueSerde();
    }

    @Override
    public String toString() {
        return "StreamSourceNode{topicNames=" + this.topicNames + ", topicPattern=" + this.topicPattern + ", consumedInternal=" + this.consumedInternal + "} " + super.toString();
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        if (this.topicPattern != null) {
            topologyBuilder.addSource(this.consumedInternal.offsetResetPolicy(), this.nodeName(), this.consumedInternal.timestampExtractor(), this.consumedInternal.keyDeserializer(), this.consumedInternal.valueDeserializer(), this.topicPattern);
        } else {
            topologyBuilder.addSource(this.consumedInternal.offsetResetPolicy(), this.nodeName(), this.consumedInternal.timestampExtractor(), this.consumedInternal.keyDeserializer(), this.consumedInternal.valueDeserializer(), this.topicNames.toArray(new String[this.topicNames.size()]));
        }
    }
}

