/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.metrics;

import java.util.Map;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;

public class ThreadMetrics {
    private static final String COMMIT = "commit";
    private static final String POLL = "poll";
    private static final String PROCESS = "process";
    private static final String PUNCTUATE = "punctuate";
    private static final String CREATE_TASK = "task-created";
    private static final String CLOSE_TASK = "task-closed";
    private static final String SKIP_RECORD = "skipped-records";
    private static final String TOTAL_DESCRIPTION = "The total number of ";
    private static final String RATE_DESCRIPTION = "The average per-second number of ";
    private static final String COMMIT_DESCRIPTION = "commit calls";
    private static final String COMMIT_TOTAL_DESCRIPTION = "The total number of commit calls";
    private static final String COMMIT_RATE_DESCRIPTION = "The average per-second number of commit calls";
    private static final String CREATE_TASK_DESCRIPTION = "newly created tasks";
    private static final String CREATE_TASK_TOTAL_DESCRIPTION = "The total number of newly created tasks";
    private static final String CREATE_TASK_RATE_DESCRIPTION = "The average per-second number of newly created tasks";
    private static final String CLOSE_TASK_DESCRIPTION = "closed tasks";
    private static final String CLOSE_TASK_TOTAL_DESCRIPTION = "The total number of closed tasks";
    private static final String CLOSE_TASK_RATE_DESCRIPTION = "The average per-second number of closed tasks";
    private static final String POLL_DESCRIPTION = "poll calls";
    private static final String POLL_TOTAL_DESCRIPTION = "The total number of poll calls";
    private static final String POLL_RATE_DESCRIPTION = "The average per-second number of poll calls";
    private static final String PROCESS_DESCRIPTION = "process calls";
    private static final String PROCESS_TOTAL_DESCRIPTION = "The total number of process calls";
    private static final String PROCESS_RATE_DESCRIPTION = "The average per-second number of process calls";
    private static final String PUNCTUATE_DESCRIPTION = "punctuate calls";
    private static final String PUNCTUATE_TOTAL_DESCRIPTION = "The total number of punctuate calls";
    private static final String PUNCTUATE_RATE_DESCRIPTION = "The average per-second number of punctuate calls";
    private static final String SKIP_RECORDS_DESCRIPTION = "skipped records";
    private static final String SKIP_RECORD_TOTAL_DESCRIPTION = "The total number of skipped records";
    private static final String SKIP_RECORD_RATE_DESCRIPTION = "The average per-second number of skipped records";
    private static final String COMMIT_OVER_TASKS_DESCRIPTION = "commit calls over all tasks";
    private static final String COMMIT_OVER_TASKS_TOTAL_DESCRIPTION = "The total number of commit calls over all tasks";
    private static final String COMMIT_OVER_TASKS_RATE_DESCRIPTION = "The average per-second number of commit calls over all tasks";
    private static final String COMMIT_LATENCY = "commit-latency";
    private static final String POLL_LATENCY = "poll-latency";
    private static final String PROCESS_LATENCY = "process-latency";
    private static final String PUNCTUATE_LATENCY = "punctuate-latency";

    private ThreadMetrics() {
    }

    public static Sensor createTaskSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        Sensor createTaskSensor = streamsMetrics.threadLevelSensor(threadId, CREATE_TASK, Sensor.RecordingLevel.INFO, new Sensor[0]);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(createTaskSensor, "stream-metrics", streamsMetrics.threadLevelTagMap(threadId), CREATE_TASK, CREATE_TASK_TOTAL_DESCRIPTION, CREATE_TASK_RATE_DESCRIPTION);
        return createTaskSensor;
    }

    public static Sensor closeTaskSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        Sensor closeTaskSensor = streamsMetrics.threadLevelSensor(threadId, CLOSE_TASK, Sensor.RecordingLevel.INFO, new Sensor[0]);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(closeTaskSensor, "stream-metrics", streamsMetrics.threadLevelTagMap(threadId), CLOSE_TASK, CLOSE_TASK_TOTAL_DESCRIPTION, CLOSE_TASK_RATE_DESCRIPTION);
        return closeTaskSensor;
    }

    public static Sensor commitSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        Sensor commitSensor = streamsMetrics.threadLevelSensor(threadId, COMMIT, Sensor.RecordingLevel.INFO, new Sensor[0]);
        Map<String, String> tagMap = streamsMetrics.threadLevelTagMap(threadId);
        StreamsMetricsImpl.addAvgAndMaxToSensor(commitSensor, "stream-metrics", tagMap, COMMIT_LATENCY);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(commitSensor, "stream-metrics", tagMap, COMMIT, COMMIT_TOTAL_DESCRIPTION, COMMIT_RATE_DESCRIPTION);
        return commitSensor;
    }

    public static Sensor pollSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        Sensor pollSensor = streamsMetrics.threadLevelSensor(threadId, POLL, Sensor.RecordingLevel.INFO, new Sensor[0]);
        Map<String, String> tagMap = streamsMetrics.threadLevelTagMap(threadId);
        StreamsMetricsImpl.addAvgAndMaxToSensor(pollSensor, "stream-metrics", tagMap, POLL_LATENCY);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(pollSensor, "stream-metrics", tagMap, POLL, POLL_TOTAL_DESCRIPTION, POLL_RATE_DESCRIPTION);
        return pollSensor;
    }

    public static Sensor processSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        Sensor processSensor = streamsMetrics.threadLevelSensor(threadId, PROCESS, Sensor.RecordingLevel.INFO, new Sensor[0]);
        Map<String, String> tagMap = streamsMetrics.threadLevelTagMap(threadId);
        StreamsMetricsImpl.addAvgAndMaxToSensor(processSensor, "stream-metrics", tagMap, PROCESS_LATENCY);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(processSensor, "stream-metrics", tagMap, PROCESS, PROCESS_TOTAL_DESCRIPTION, PROCESS_RATE_DESCRIPTION);
        return processSensor;
    }

    public static Sensor punctuateSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        Sensor punctuateSensor = streamsMetrics.threadLevelSensor(threadId, PUNCTUATE, Sensor.RecordingLevel.INFO, new Sensor[0]);
        Map<String, String> tagMap = streamsMetrics.threadLevelTagMap(threadId);
        StreamsMetricsImpl.addAvgAndMaxToSensor(punctuateSensor, "stream-metrics", tagMap, PUNCTUATE_LATENCY);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(punctuateSensor, "stream-metrics", tagMap, PUNCTUATE, PUNCTUATE_TOTAL_DESCRIPTION, PUNCTUATE_RATE_DESCRIPTION);
        return punctuateSensor;
    }

    public static Sensor skipRecordSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        Sensor skippedRecordsSensor = streamsMetrics.threadLevelSensor(threadId, SKIP_RECORD, Sensor.RecordingLevel.INFO, new Sensor[0]);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(skippedRecordsSensor, "stream-metrics", streamsMetrics.threadLevelTagMap(threadId), SKIP_RECORD, SKIP_RECORD_TOTAL_DESCRIPTION, SKIP_RECORD_RATE_DESCRIPTION);
        return skippedRecordsSensor;
    }

    public static Sensor commitOverTasksSensor(String threadId, StreamsMetricsImpl streamsMetrics) {
        Sensor commitOverTasksSensor = streamsMetrics.threadLevelSensor(threadId, COMMIT, Sensor.RecordingLevel.DEBUG, new Sensor[0]);
        Map<String, String> tagMap = streamsMetrics.threadLevelTagMap(threadId, "task-id", "all");
        StreamsMetricsImpl.addAvgAndMaxToSensor(commitOverTasksSensor, "stream-task-metrics", tagMap, COMMIT_LATENCY);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(commitOverTasksSensor, "stream-task-metrics", tagMap, COMMIT, COMMIT_OVER_TASKS_TOTAL_DESCRIPTION, COMMIT_OVER_TASKS_RATE_DESCRIPTION);
        return commitOverTasksSensor;
    }
}

