/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.MeteredWindowStore;
import org.apache.kafka.streams.state.internals.ValueAndTimestampSerde;

class MeteredTimestampedWindowStore<K, V>
extends MeteredWindowStore<K, ValueAndTimestamp<V>>
implements TimestampedWindowStore<K, V> {
    MeteredTimestampedWindowStore(WindowStore<Bytes, byte[]> inner, long windowSizeMs, String metricScope, Time time, Serde<K> keySerde, Serde<ValueAndTimestamp<V>> valueSerde) {
        super(inner, windowSizeMs, metricScope, time, keySerde, valueSerde);
    }

    @Override
    void initStoreSerde(ProcessorContext context) {
        this.serdes = new StateSerdes(ProcessorStateManager.storeChangelogTopic(context.applicationId(), this.name()), this.keySerde == null ? context.keySerde() : this.keySerde, this.valueSerde == null ? new ValueAndTimestampSerde(context.valueSerde()) : this.valueSerde);
    }
}

