/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingWindowBytesStore;
import org.apache.kafka.streams.state.internals.ValueAndTimestampDeserializer;

class ChangeLoggingTimestampedWindowBytesStore
extends ChangeLoggingWindowBytesStore {
    ChangeLoggingTimestampedWindowBytesStore(WindowStore<Bytes, byte[]> bytesStore, boolean retainDuplicates) {
        super(bytesStore, retainDuplicates);
    }

    @Override
    void log(Bytes key, byte[] valueAndTimestamp) {
        if (valueAndTimestamp != null) {
            this.changeLogger.logChange(key, ValueAndTimestampDeserializer.rawValue(valueAndTimestamp), ValueAndTimestampDeserializer.timestamp(valueAndTimestamp));
        } else {
            this.changeLogger.logChange(key, null);
        }
    }
}

