/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.internals.QuietStreamsConfig;
import org.apache.kafka.streams.processor.PartitionGrouper;
import org.apache.kafka.streams.processor.internals.InternalTopicManager;
import org.apache.kafka.streams.processor.internals.TaskManager;
import org.apache.kafka.streams.processor.internals.assignment.CopartitionedTopicsEnforcer;
import org.slf4j.Logger;

public final class AssignorConfiguration {
    private final String logPrefix;
    private final Logger log;
    private final Integer numStandbyReplicas;
    private final PartitionGrouper partitionGrouper;
    private final String userEndPoint;
    private final TaskManager taskManager;
    private final InternalTopicManager internalTopicManager;
    private final CopartitionedTopicsEnforcer copartitionedTopicsEnforcer;
    private final StreamsConfig streamsConfig;

    public AssignorConfiguration(Map<String, ?> configs) {
        KafkaException fatalException;
        this.streamsConfig = new QuietStreamsConfig(configs);
        this.logPrefix = String.format("stream-thread [%s] ", this.streamsConfig.getString("client.id"));
        LogContext logContext = new LogContext(this.logPrefix);
        this.log = logContext.logger(this.getClass());
        this.numStandbyReplicas = this.streamsConfig.getInt("num.standby.replicas");
        this.partitionGrouper = (PartitionGrouper)this.streamsConfig.getConfiguredInstance("partition.grouper", PartitionGrouper.class);
        String configuredUserEndpoint = this.streamsConfig.getString("application.server");
        if (configuredUserEndpoint != null && !configuredUserEndpoint.isEmpty()) {
            try {
                String host = Utils.getHost((String)configuredUserEndpoint);
                Integer port = Utils.getPort((String)configuredUserEndpoint);
                if (host == null || port == null) {
                    throw new ConfigException(String.format("%s Config %s isn't in the correct format. Expected a host:port pair but received %s", this.logPrefix, "application.server", configuredUserEndpoint));
                }
            }
            catch (NumberFormatException nfe) {
                throw new ConfigException(String.format("%s Invalid port supplied in %s for config %s: %s", this.logPrefix, configuredUserEndpoint, "application.server", nfe));
            }
            this.userEndPoint = configuredUserEndpoint;
        } else {
            this.userEndPoint = null;
        }
        Object o = configs.get("__task.manager.instance__");
        if (o == null) {
            fatalException = new KafkaException("TaskManager is not specified");
            this.log.error(fatalException.getMessage(), (Throwable)fatalException);
            throw fatalException;
        }
        if (!(o instanceof TaskManager)) {
            fatalException = new KafkaException(String.format("%s is not an instance of %s", o.getClass().getName(), TaskManager.class.getName()));
            this.log.error(fatalException.getMessage(), (Throwable)fatalException);
            throw fatalException;
        }
        this.taskManager = (TaskManager)o;
        this.internalTopicManager = new InternalTopicManager(this.taskManager.adminClient(), this.streamsConfig);
        this.copartitionedTopicsEnforcer = new CopartitionedTopicsEnforcer(this.logPrefix);
    }

    public AtomicInteger getAssignmentErrorCode(Map<String, ?> configs) {
        Object ai = configs.get("__assignment.error.code__");
        if (ai == null) {
            KafkaException fatalException = new KafkaException("assignmentErrorCode is not specified");
            this.log.error(fatalException.getMessage(), (Throwable)fatalException);
            throw fatalException;
        }
        if (!(ai instanceof AtomicInteger)) {
            KafkaException fatalException = new KafkaException(String.format("%s is not an instance of %s", ai.getClass().getName(), AtomicInteger.class.getName()));
            this.log.error(fatalException.getMessage(), (Throwable)fatalException);
            throw fatalException;
        }
        return (AtomicInteger)ai;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public ConsumerPartitionAssignor.RebalanceProtocol rebalanceProtocol() {
        String upgradeFrom = this.streamsConfig.getString("upgrade.from");
        if (upgradeFrom != null) {
            switch (upgradeFrom) {
                case "0.10.0": 
                case "0.10.1": 
                case "0.10.2": 
                case "0.11.0": 
                case "1.0": 
                case "1.1": 
                case "2.0": 
                case "2.1": 
                case "2.2": 
                case "2.3": {
                    this.log.info("Eager rebalancing enabled now for upgrade from {}.x", (Object)upgradeFrom);
                    return ConsumerPartitionAssignor.RebalanceProtocol.EAGER;
                }
            }
            throw new IllegalArgumentException("Unknown configuration value for parameter 'upgrade.from': " + upgradeFrom);
        }
        this.log.info("Cooperative rebalancing enabled now");
        return ConsumerPartitionAssignor.RebalanceProtocol.COOPERATIVE;
    }

    public String logPrefix() {
        return this.logPrefix;
    }

    public int configuredMetadataVersion(int priorVersion) {
        String upgradeFrom = this.streamsConfig.getString("upgrade.from");
        if (upgradeFrom != null) {
            switch (upgradeFrom) {
                case "0.10.0": {
                    this.log.info("Downgrading metadata version from {} to 1 for upgrade from 0.10.0.x.", (Object)6);
                    return 1;
                }
                case "0.10.1": 
                case "0.10.2": 
                case "0.11.0": 
                case "1.0": 
                case "1.1": {
                    this.log.info("Downgrading metadata version from {} to 2 for upgrade from {}.x.", (Object)6, (Object)upgradeFrom);
                    return 2;
                }
                case "2.0": 
                case "2.1": 
                case "2.2": 
                case "2.3": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown configuration value for parameter 'upgrade.from': " + upgradeFrom);
                }
            }
        }
        return priorVersion;
    }

    public int getNumStandbyReplicas() {
        return this.numStandbyReplicas;
    }

    public PartitionGrouper getPartitionGrouper() {
        return this.partitionGrouper;
    }

    public String getUserEndPoint() {
        return this.userEndPoint;
    }

    public InternalTopicManager getInternalTopicManager() {
        return this.internalTopicManager;
    }

    public CopartitionedTopicsEnforcer getCopartitionedTopicsEnforcer() {
        return this.copartitionedTopicsEnforcer;
    }
}

